/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostclient.model.csdl;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import de.fraunhofer.iosb.ilt.frostclient.model.EntityType;
import de.fraunhofer.iosb.ilt.frostclient.model.ModelRegistry;
import de.fraunhofer.iosb.ilt.frostclient.model.PropertyType;
import de.fraunhofer.iosb.ilt.frostclient.model.csdl.CsdlAnnotation;
import de.fraunhofer.iosb.ilt.frostclient.model.csdl.CsdlDocument;
import de.fraunhofer.iosb.ilt.frostclient.model.csdl.CsdlProperty;
import de.fraunhofer.iosb.ilt.frostclient.model.csdl.annotation.Annotation;
import de.fraunhofer.iosb.ilt.frostclient.model.property.EntityPropertyMain;
import de.fraunhofer.iosb.ilt.frostclient.model.property.type.TypeCollection;
import de.fraunhofer.iosb.ilt.frostclient.model.property.type.TypeComplex;
import de.fraunhofer.iosb.ilt.frostclient.model.property.type.TypePrimitive;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class CsdlPropertyEntity
extends CsdlProperty {
    public static final String NAME_KIND_ENTITYPROPERTY = "Property";
    private static final String TYPE_DEFAULT = "Edm.String";
    @JsonProperty(value="$Type")
    public String type;
    @JsonProperty(value="$Nullable")
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    public boolean nullable;
    @JsonProperty(value="$Collection")
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    public boolean collection;
    @JsonIgnore
    private final List<CsdlAnnotation> annotations = new ArrayList<CsdlAnnotation>();

    public CsdlPropertyEntity() {
        super(NAME_KIND_ENTITYPROPERTY);
    }

    public CsdlPropertyEntity fillFrom(CsdlDocument doc, String nameSpace, EntityType et, EntityPropertyMain<?> ep) {
        PropertyType propertyType = ep.getType();
        this.type = propertyType.getName();
        this.collection = propertyType.isCollection();
        if (et.getPrimaryKey() != ep) {
            this.nullable = ep.isNullable();
        }
        for (Annotation an : ep.getAnnotations()) {
            this.annotations.add(CsdlAnnotation.of(doc, an));
        }
        return this;
    }

    public CsdlPropertyEntity fillFrom(CsdlDocument doc, String nameSpace, PropertyType propertyType, boolean nullable) {
        this.type = propertyType.getName();
        this.nullable = nullable;
        this.collection = propertyType.isCollection();
        for (Annotation an : propertyType.getAnnotations()) {
            this.annotations.add(CsdlAnnotation.of(doc, an));
        }
        return this;
    }

    @Override
    public void applyTo(ModelRegistry mr, EntityType entityType, String name) {
        EntityPropertyMain ep = this.createProperty(mr, name);
        entityType.registerProperty(ep);
    }

    @Override
    public void applyTo(ModelRegistry mr, TypeComplex tc, String name) {
        EntityPropertyMain ep = this.createProperty(mr, name);
        tc.registerProperty(ep);
    }

    private EntityPropertyMain createProperty(ModelRegistry mr, String name) throws IllegalArgumentException {
        PropertyType propertyType = mr.getPropertyType(this.type);
        if (this.collection) {
            if (propertyType instanceof TypePrimitive) {
                TypePrimitive ptp = (TypePrimitive)propertyType;
                propertyType = new TypeCollection(ptp, null);
            } else if (propertyType instanceof TypeComplex) {
                TypeComplex ptc = (TypeComplex)propertyType;
                propertyType = new TypeCollection(ptc, null);
            } else {
                throw new IllegalArgumentException("Can't create Type for Set of " + propertyType.getName());
            }
        }
        EntityPropertyMain ep = new EntityPropertyMain(name, propertyType);
        ep.setNullable(this.nullable);
        return ep;
    }

    @JsonAnyGetter
    public Map<String, Object> otherProperties() {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        for (CsdlAnnotation annotation : this.annotations) {
            result.put("@" + annotation.getQualifiedName(), annotation.getValue());
        }
        return result;
    }

    @Override
    public void writeXml(String nameSpace, String name, Writer writer) throws IOException {
        Object typeString;
        Object object = typeString = this.type == null ? TYPE_DEFAULT : this.type;
        if (this.collection) {
            typeString = "Collection(" + (String)typeString + ")";
        }
        String nullableString = this.nullable ? " Nullable=\"" + Boolean.toString(this.nullable) + "\"" : "";
        writer.write("<Property Name=\"" + name + "\" Type=\"" + (String)typeString + "\"" + nullableString);
        if (this.annotations.isEmpty()) {
            writer.write(" />");
        } else {
            writer.write(">");
            for (CsdlAnnotation an : this.annotations) {
                an.writeXml(writer);
            }
            writer.write("</Property>");
        }
    }

    public CsdlPropertyEntity setType(String type) {
        this.type = type;
        return this;
    }

    public CsdlPropertyEntity setNullable(boolean nullable) {
        this.nullable = nullable;
        return this;
    }

    public CsdlPropertyEntity setCollection(boolean collection) {
        this.collection = collection;
        return this;
    }

    public static CsdlPropertyEntity of(CsdlDocument doc, String nameSpace, EntityType et, EntityPropertyMain<?> ep) {
        return new CsdlPropertyEntity().fillFrom(doc, nameSpace, et, ep);
    }

    public static CsdlPropertyEntity of(CsdlDocument doc, String nameSpace, PropertyType type, boolean nullable) {
        return new CsdlPropertyEntity().fillFrom(doc, nameSpace, type, nullable);
    }
}

