/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostclient.model.csdl;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import de.fraunhofer.iosb.ilt.frostclient.model.EntityType;
import de.fraunhofer.iosb.ilt.frostclient.model.ModelRegistry;
import de.fraunhofer.iosb.ilt.frostclient.model.PkSingle;
import de.fraunhofer.iosb.ilt.frostclient.model.csdl.CsdlAnnotation;
import de.fraunhofer.iosb.ilt.frostclient.model.csdl.CsdlDocument;
import de.fraunhofer.iosb.ilt.frostclient.model.csdl.CsdlProperty;
import de.fraunhofer.iosb.ilt.frostclient.model.csdl.CsdlPropertyEntity;
import de.fraunhofer.iosb.ilt.frostclient.model.csdl.CsdlPropertyNavigation;
import de.fraunhofer.iosb.ilt.frostclient.model.csdl.CsdlSchemaItemAbstract;
import de.fraunhofer.iosb.ilt.frostclient.model.csdl.annotation.Annotation;
import de.fraunhofer.iosb.ilt.frostclient.model.property.EntityPropertyMain;
import de.fraunhofer.iosb.ilt.frostclient.model.property.NavigationProperty;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.NotImplementedException;

public class CsdlItemEntityType
extends CsdlSchemaItemAbstract {
    public static final String NAME_KIND_ENTITYTYPE = "EntityType";
    @JsonProperty(value="$Key")
    public List<String> key = new ArrayList<String>();
    @JsonIgnore
    public Map<String, CsdlProperty> properties = new LinkedHashMap<String, CsdlProperty>();
    @JsonIgnore
    private final List<CsdlAnnotation> annotations = new ArrayList<CsdlAnnotation>();
    @JsonIgnore
    private String namespace;

    public CsdlItemEntityType() {
        super(NAME_KIND_ENTITYTYPE);
    }

    public CsdlItemEntityType fillFrom(CsdlDocument doc, String nameSpace, EntityType et) {
        this.namespace = nameSpace;
        for (EntityPropertyMain keyProp : et.getPrimaryKey().getKeyProperties()) {
            String keyName = keyProp.getJsonName();
            if ("@iot.id".equals(keyName)) {
                keyName = "id";
            }
            this.key.add(keyName);
        }
        for (EntityPropertyMain ep : et.getEntityProperties()) {
            if (ep == ModelRegistry.EP_SELFLINK) continue;
            String propertyName = ep.getJsonName();
            if ("@iot.id".equals(propertyName)) {
                propertyName = "id";
            }
            this.properties.put(propertyName, CsdlPropertyEntity.of(doc, nameSpace, et, ep));
        }
        for (NavigationProperty np : et.getNavigationProperties()) {
            this.properties.put(np.getJsonName(), CsdlPropertyNavigation.of(doc, nameSpace, et, np));
        }
        for (Annotation an : et.getAnnotations()) {
            this.annotations.add(CsdlAnnotation.of(doc, an));
        }
        return this;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void applyTo(ModelRegistry mr, String name) {
        EntityType entityType = new EntityType(name);
        entityType.setNamespace(this.namespace);
        mr.registerEntityType(entityType);
    }

    public void applyPropertiesTo(ModelRegistry mr, String name) {
        EntityType entityType = mr.getEntityTypeForName(name);
        for (Map.Entry<String, CsdlProperty> entry : this.properties.entrySet()) {
            entry.getValue().applyTo(mr, entityType, entry.getKey());
        }
        if (this.key.size() != 1) {
            throw new NotImplementedException("Multi-Keyed entity types are not supported yet.");
        }
        EntityPropertyMain keyProp = entityType.getEntityProperty(this.key.get(0));
        keyProp.setReadOnly(true);
        PkSingle pk = new PkSingle(keyProp);
        entityType.setPrimaryKey(pk);
    }

    @JsonAnyGetter
    public Map<String, Object> otherProperties() {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        for (Map.Entry<String, CsdlProperty> entry : this.properties.entrySet()) {
            result.put(entry.getKey(), entry.getValue());
        }
        for (CsdlAnnotation annotation : this.annotations) {
            result.put("@" + annotation.getQualifiedName(), annotation.getValue());
        }
        return result;
    }

    @JsonAnySetter
    public void addProperty(String name, Object data) {
        if (!name.startsWith("@")) {
            if (data instanceof CsdlProperty) {
                CsdlProperty p = (CsdlProperty)data;
                this.properties.put(name, p);
            } else if (data instanceof Map) {
                Map map = (Map)data;
                this.properties.put(name, CsdlProperty.of(name, map));
            }
        }
    }

    @Override
    public void writeXml(String nameSpace, String name, Writer writer) throws IOException {
        writer.write("<EntityType Name=\"" + name + "\">");
        writer.write("<Key>");
        for (String string : this.key) {
            writer.write("<PropertyRef Name=\"" + string + "\" />");
        }
        writer.write("</Key>");
        for (Map.Entry entry : this.properties.entrySet()) {
            String propName = (String)entry.getKey();
            CsdlProperty property = (CsdlProperty)entry.getValue();
            property.writeXml(nameSpace, propName, writer);
        }
        for (CsdlAnnotation csdlAnnotation : this.annotations) {
            csdlAnnotation.writeXml(writer);
        }
        writer.write("</EntityType>");
    }

    public static CsdlItemEntityType of(CsdlDocument doc, String nameSpace, EntityType et) {
        return new CsdlItemEntityType().fillFrom(doc, nameSpace, et);
    }
}

