/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostclient.model.csdl;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import de.fraunhofer.iosb.ilt.frostclient.model.EntityType;
import de.fraunhofer.iosb.ilt.frostclient.model.ModelRegistry;
import de.fraunhofer.iosb.ilt.frostclient.model.csdl.CsdlSchemaItemAbstract;
import de.fraunhofer.iosb.ilt.frostclient.model.property.NavigationProperty;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

public class CsdlItemEntityContainer
extends CsdlSchemaItemAbstract {
    public static final String NAME_KIND_ENTITYCONTAINER = "EntityContainer";
    @JsonAnyGetter
    @JsonAnySetter
    public Map<String, ContainerItem> containers = new LinkedHashMap<String, ContainerItem>();

    public CsdlItemEntityContainer() {
        super(NAME_KIND_ENTITYCONTAINER);
    }

    public CsdlItemEntityContainer fillFrom(String nameSpace, ModelRegistry registry) {
        for (Map.Entry<String, EntityType> container : registry.getContainers().entrySet()) {
            this.containers.put(container.getKey(), ContainerItem.of(nameSpace, container.getValue()));
        }
        return this;
    }

    public void applyTo(ModelRegistry mr, String name) {
        for (Map.Entry<String, ContainerItem> entry : this.containers.entrySet()) {
            entry.getValue().applyTo(mr, entry.getKey());
        }
    }

    @Override
    public void writeXml(String nameSpace, String name, Writer writer) throws IOException {
        writer.write("<EntityContainer Name=\"" + name + "\">");
        for (Map.Entry<String, ContainerItem> entry : this.containers.entrySet()) {
            String propName = entry.getKey();
            ContainerItem property = entry.getValue();
            property.writeXml(propName, writer);
        }
        writer.write("</EntityContainer>");
    }

    public static CsdlItemEntityContainer of(String nameSpace, ModelRegistry registry) {
        return new CsdlItemEntityContainer().fillFrom(nameSpace, registry);
    }

    public static class ContainerItem {
        @JsonProperty(value="$Collection")
        @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
        public Boolean collection;
        @JsonProperty(value="$Type")
        public String type;
        @JsonProperty(value="$NavigationPropertyBinding")
        public Map<String, String> navPropBinding = new HashMap<String, String>();

        public ContainerItem fillFrom(String nameSpace, EntityType et) {
            this.collection = true;
            this.type = et.entityName;
            for (NavigationProperty np : et.getNavigationProperties()) {
                this.navPropBinding.put(np.getName(), np.getEntityType().mainContainer);
            }
            return this;
        }

        public void applyTo(ModelRegistry mr, String name) {
            EntityType entityType = mr.getEntityTypeForName(this.type);
            entityType.setMainContainer(name);
            mr.registerEntityContainer(name, entityType);
        }

        public void writeXml(String name, Writer writer) throws IOException {
            writer.write("<EntitySet Name=\"" + name + "\" EntityType=\"" + this.type + "\">");
            for (Map.Entry<String, String> entry : this.navPropBinding.entrySet()) {
                writer.write("<NavigationPropertyBinding Path=\"" + entry.getKey() + "\" Target=\"" + entry.getValue() + "\" />");
            }
            writer.write("</EntitySet>");
        }

        public static ContainerItem of(String nameSpace, EntityType et) {
            return new ContainerItem().fillFrom(nameSpace, et);
        }
    }
}

