/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostclient.model.csdl;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import de.fraunhofer.iosb.ilt.frostclient.model.ModelRegistry;
import de.fraunhofer.iosb.ilt.frostclient.model.Property;
import de.fraunhofer.iosb.ilt.frostclient.model.PropertyType;
import de.fraunhofer.iosb.ilt.frostclient.model.csdl.CsdlDocument;
import de.fraunhofer.iosb.ilt.frostclient.model.csdl.CsdlProperty;
import de.fraunhofer.iosb.ilt.frostclient.model.csdl.CsdlPropertyEntity;
import de.fraunhofer.iosb.ilt.frostclient.model.csdl.CsdlSchemaItemAbstract;
import de.fraunhofer.iosb.ilt.frostclient.model.property.type.TypeComplex;
import de.fraunhofer.iosb.ilt.frostclient.utils.ParserUtils;
import java.io.IOException;
import java.io.Writer;
import java.util.LinkedHashMap;
import java.util.Map;

public class CsdlItemComplexType
extends CsdlSchemaItemAbstract {
    public static final String NAME_KIND_COMPLEXTYPE = "ComplexType";
    @JsonProperty(value="$OpenType")
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    public boolean openType;
    @JsonProperty(value="@Core.Description")
    public String description;
    @JsonAnyGetter
    public Map<String, CsdlProperty> properties = new LinkedHashMap<String, CsdlProperty>();

    public CsdlItemComplexType() {
        super(NAME_KIND_COMPLEXTYPE);
    }

    public CsdlItemComplexType fillFrom(CsdlDocument doc, String nameSpace, TypeComplex tc) {
        this.description = tc.getDescription();
        this.openType = tc.isOpenType();
        for (Property property : tc.getProperties()) {
            String name = property.getName();
            PropertyType type = property.getType();
            boolean nullable = property.isNullable();
            this.properties.put(name, CsdlPropertyEntity.of(doc, nameSpace, type, nullable));
        }
        return this;
    }

    public void applyTo(ModelRegistry mr, String name) {
        TypeComplex type = new TypeComplex(name, this.description, this.openType);
        type.setDeserializer(ParserUtils.getComplexTypeDeserializer(type));
        type.setSerializer(ParserUtils.getDefaultSerializer());
        for (Map.Entry<String, CsdlProperty> propEntry : this.properties.entrySet()) {
            String propName = propEntry.getKey();
            CsdlProperty property = propEntry.getValue();
            property.applyTo(mr, type, propName);
        }
        mr.registerPropertyType(type);
    }

    public CsdlItemComplexType setOpenType(boolean openType) {
        this.openType = openType;
        return this;
    }

    @JsonAnySetter
    public void addProperty(String name, Object data) {
        if (!name.startsWith("@") && data instanceof Map) {
            Map map = (Map)data;
            this.properties.put(name, CsdlProperty.of(name, map));
        }
    }

    @Override
    public void writeXml(String nameSpace, String name, Writer writer) throws IOException {
        writer.write("<ComplexType Name=\"" + name + "\" OpenType=\"" + Boolean.toString(this.openType) + "\">");
        for (Map.Entry<String, CsdlProperty> entry : this.properties.entrySet()) {
            String propName = entry.getKey();
            CsdlProperty property = entry.getValue();
            property.writeXml(nameSpace, propName, writer);
        }
        writer.write("</ComplexType>");
    }

    public static CsdlItemComplexType of(CsdlDocument doc, String nameSpace, TypeComplex tc) {
        return new CsdlItemComplexType().fillFrom(doc, nameSpace, tc);
    }
}

