/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostclient.json.serialize;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.module.SimpleModule;
import de.fraunhofer.iosb.ilt.frostclient.json.deserialize.mixins.AbstractConstraintMixin;
import de.fraunhofer.iosb.ilt.frostclient.json.deserialize.mixins.AbstractDataComponentMixin;
import de.fraunhofer.iosb.ilt.frostclient.json.deserialize.mixins.AbstractSWEIdentifiableMixin;
import de.fraunhofer.iosb.ilt.frostclient.json.serialize.EntitySerializer;
import de.fraunhofer.iosb.ilt.frostclient.json.serialize.MomentSerializer;
import de.fraunhofer.iosb.ilt.frostclient.json.serialize.TimeObjectSerializer;
import de.fraunhofer.iosb.ilt.frostclient.model.Entity;
import de.fraunhofer.iosb.ilt.frostclient.models.ext.TimeObject;
import de.fraunhofer.iosb.ilt.swe.common.AbstractDataComponent;
import de.fraunhofer.iosb.ilt.swe.common.AbstractSWEIdentifiable;
import de.fraunhofer.iosb.ilt.swe.common.constraint.AbstractConstraint;
import java.io.IOException;
import java.io.Writer;
import net.time4j.Moment;

public class JsonWriter {
    private static ObjectMapper objectMapperInstance;

    public static ObjectMapper getObjectMapper() {
        if (objectMapperInstance == null) {
            JsonWriter.initObjectMapper();
        }
        return objectMapperInstance;
    }

    private static synchronized void initObjectMapper() {
        if (objectMapperInstance == null) {
            objectMapperInstance = JsonWriter.createObjectMapper();
        }
    }

    private static ObjectMapper createObjectMapper() {
        ObjectMapper mapper = new ObjectMapper().setSerializationInclusion(JsonInclude.Include.NON_EMPTY).disable(SerializationFeature.FAIL_ON_EMPTY_BEANS).disable(SerializationFeature.FLUSH_AFTER_WRITE_VALUE).addMixIn(AbstractDataComponent.class, AbstractDataComponentMixin.class).addMixIn(AbstractSWEIdentifiable.class, AbstractSWEIdentifiableMixin.class).addMixIn(AbstractConstraint.class, AbstractConstraintMixin.class);
        SimpleModule module = new SimpleModule();
        module.addSerializer(Entity.class, (JsonSerializer)new EntitySerializer());
        module.addSerializer(TimeObject.class, (JsonSerializer)new TimeObjectSerializer());
        module.addSerializer(Moment.class, (JsonSerializer)new MomentSerializer());
        mapper.registerModule((Module)module);
        return mapper;
    }

    private JsonWriter() {
    }

    public static void writeEntity(Writer writer, Entity entity) throws IOException {
        JsonWriter.getObjectMapper().writeValue(writer, (Object)entity);
    }

    public static String writeEntity(Entity entity) throws JsonProcessingException {
        return JsonWriter.getObjectMapper().writeValueAsString((Object)entity);
    }

    public static byte[] writeBytes(Entity entity) throws JsonProcessingException {
        return JsonWriter.getObjectMapper().writeValueAsBytes((Object)entity);
    }

    public static void writeObject(Writer writer, Object object) throws IOException {
        JsonWriter.getObjectMapper().writeValue(writer, object);
    }

    public static String writeObject(Object object) throws JsonProcessingException {
        return JsonWriter.getObjectMapper().writeValueAsString(object);
    }
}

