/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostclient.json.deserialize;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.exc.UnrecognizedPropertyException;
import de.fraunhofer.iosb.ilt.frostclient.json.deserialize.EntityDeserializer;
import de.fraunhofer.iosb.ilt.frostclient.model.EntitySet;
import de.fraunhofer.iosb.ilt.frostclient.model.EntitySetImpl;
import de.fraunhofer.iosb.ilt.frostclient.model.EntityType;
import de.fraunhofer.iosb.ilt.frostclient.model.ModelRegistry;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class EntitySetDeserializer
extends JsonDeserializer<EntitySet> {
    private static final Map<ModelRegistry, Map<EntityType, EntitySetDeserializer>> instancePerModelAndType = new HashMap<ModelRegistry, Map<EntityType, EntitySetDeserializer>>();
    private final EntityType entityType;
    private final ModelRegistry modelRegistry;

    public static EntitySetDeserializer getInstance(ModelRegistry modelRegistry, EntityType entityType) {
        return instancePerModelAndType.computeIfAbsent(modelRegistry, t -> new HashMap()).computeIfAbsent(entityType, t -> new EntitySetDeserializer(modelRegistry, (EntityType)t));
    }

    public EntitySetDeserializer(ModelRegistry modelRegistry, EntityType entityType) {
        this.modelRegistry = modelRegistry;
        this.entityType = entityType;
    }

    public EntitySet deserializeFull(JsonParser parser, DeserializationContext ctxt) throws IOException {
        parser.nextToken();
        EntitySet result = this.deserialize(parser, ctxt);
        parser.nextToken();
        return result;
    }

    public EntitySet deserialize(JsonParser parser, DeserializationContext ctxt) throws IOException {
        EntitySetImpl result = new EntitySetImpl(this.entityType);
        boolean failOnUnknown = ctxt.isEnabled(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        JsonToken currentToken = parser.nextToken();
        while (currentToken == JsonToken.FIELD_NAME) {
            String fieldName = parser.getCurrentName();
            parser.nextValue();
            if (fieldName.endsWith("count")) {
                result.setCount((Long)parser.readValueAs(Long.class));
            } else if (fieldName.endsWith("nextLink")) {
                result.setNextLink((String)parser.readValueAs(String.class));
            } else if ("value".equals(fieldName)) {
                this.deserialiseEntitySet(parser, ctxt, result);
            } else if (failOnUnknown) {
                String message = "Unknown field: " + fieldName + " on " + this.entityType.entityName + " set.";
                throw new UnrecognizedPropertyException(parser, message, parser.getCurrentLocation(), EntitySet.class, fieldName, null);
            }
            currentToken = parser.nextToken();
        }
        return result;
    }

    private void deserialiseEntitySet(JsonParser parser, DeserializationContext ctxt, EntitySet targetSet) throws IOException {
        EntityDeserializer entityDeser = EntityDeserializer.getInstance(this.modelRegistry, targetSet.getEntityType());
        JsonToken curToken = parser.nextToken();
        while (curToken != null && curToken != JsonToken.END_ARRAY) {
            targetSet.add(entityDeser.deserialize(parser, ctxt));
            curToken = parser.nextToken();
        }
    }
}

