/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostclient.dao;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.github.fge.jsonpatch.JsonPatchOperation;
import de.fraunhofer.iosb.ilt.frostclient.SensorThingsService;
import de.fraunhofer.iosb.ilt.frostclient.dao.Dao;
import de.fraunhofer.iosb.ilt.frostclient.exception.ServiceFailureException;
import de.fraunhofer.iosb.ilt.frostclient.json.serialize.JsonWriter;
import de.fraunhofer.iosb.ilt.frostclient.model.Entity;
import de.fraunhofer.iosb.ilt.frostclient.model.EntityType;
import de.fraunhofer.iosb.ilt.frostclient.model.property.NavigationPropertyEntity;
import de.fraunhofer.iosb.ilt.frostclient.model.property.NavigationPropertyEntitySet;
import de.fraunhofer.iosb.ilt.frostclient.query.Query;
import de.fraunhofer.iosb.ilt.frostclient.utils.ParserUtils;
import de.fraunhofer.iosb.ilt.frostclient.utils.Utils;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.List;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.http.Consts;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.ParseException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseDao
implements Dao {
    public static final ContentType APPLICATION_JSON_PATCH = ContentType.create((String)"application/json-patch+json", (Charset)Consts.UTF_8);
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseDao.class);
    private final SensorThingsService service;
    private final EntityType entityType;
    private final Entity parent;
    private final NavigationPropertyEntitySet navigationLink;

    public BaseDao(SensorThingsService service, EntityType entityType) {
        this.service = service;
        this.entityType = entityType;
        this.parent = null;
        this.navigationLink = null;
    }

    public BaseDao(SensorThingsService service, Entity parent, NavigationPropertyEntitySet navigationLink) {
        this.service = service;
        this.entityType = navigationLink.getEntityType();
        this.parent = parent;
        this.navigationLink = navigationLink;
        if (!parent.getEntityType().getNavigationSets().contains(navigationLink)) {
            throw new IllegalArgumentException("Entities of type " + this.entityType + " don't have a navigationProperty " + navigationLink);
        }
    }

    private URL getSetPath() throws ServiceFailureException {
        if (this.parent == null) {
            return this.service.getFullPath(this.entityType);
        }
        return this.service.getFullPath(this.parent, this.navigationLink);
    }

    @Override
    public void create(Entity entity) throws ServiceFailureException {
        HttpPost httpPost;
        String json;
        try {
            URIBuilder uriBuilder = new URIBuilder(this.getSetPath().toURI());
            json = JsonWriter.writeEntity(entity);
            httpPost = new HttpPost(uriBuilder.build());
        }
        catch (JsonProcessingException | URISyntaxException ex) {
            throw new ServiceFailureException("Failed to create entity.", ex);
        }
        LOGGER.debug("Posting to: {}", (Object)httpPost.getURI());
        httpPost.setEntity((HttpEntity)new StringEntity(json, ContentType.APPLICATION_JSON));
        try (CloseableHttpResponse response = this.service.execute((HttpRequestBase)httpPost);){
            Utils.throwIfNotOk((HttpRequestBase)httpPost, response);
            Header locationHeader = response.getLastHeader("location");
            EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
            if (locationHeader == null) {
                throw new IllegalStateException("Server did not send a location header for the new entitiy.");
            }
            String newLocation = locationHeader.getValue();
            int pos1 = newLocation.indexOf(40) + 1;
            int pos2 = newLocation.indexOf(41, pos1);
            String stringPkValue = newLocation.substring(pos1, pos2);
            entity.setPrimaryKeyValues(ParserUtils.tryToParse(stringPkValue));
            entity.setService(this.service);
        }
        catch (IOException exc) {
            throw new ServiceFailureException("Failed to create entity.", exc);
        }
    }

    @Override
    public Entity find(Object ... pkValues) throws ServiceFailureException {
        try {
            URI uri = this.buildUri(pkValues);
            return this.find(uri);
        }
        catch (URISyntaxException ex) {
            throw new ServiceFailureException(ex);
        }
    }

    @Override
    public Entity find(Entity parent, NavigationPropertyEntity npe) throws ServiceFailureException {
        if (!parent.getEntityType().getNavigationEntities().contains(npe)) {
            throw new IllegalArgumentException("Entities of type " + parent + " don't have nav prop " + npe);
        }
        try {
            return this.find(this.service.getFullPath(parent, npe).toURI());
        }
        catch (URISyntaxException ex) {
            throw new ServiceFailureException(ex);
        }
    }

    @Override
    public Entity find(URI uri) throws ServiceFailureException {
        Entity entity;
        block8: {
            HttpGet httpGet = new HttpGet(uri);
            LOGGER.debug("Fetching: {}", (Object)uri);
            httpGet.addHeader("Accept", ContentType.APPLICATION_JSON.getMimeType());
            CloseableHttpResponse response = this.service.execute((HttpRequestBase)httpGet);
            try {
                Utils.throwIfNotOk((HttpRequestBase)httpGet, response);
                String returnContent = EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)Consts.UTF_8);
                Entity entity2 = this.service.getJsonReader().parseEntity(this.entityType, returnContent);
                entity2.setService(this.service);
                entity = entity2;
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | ParseException ex) {
                    throw new ServiceFailureException(ex);
                }
            }
            response.close();
        }
        return entity;
    }

    @Override
    public void update(Entity entity) throws ServiceFailureException {
        HttpPatch httpPatch;
        String json;
        try {
            URI uri = this.buildUri(entity.getPrimaryKeyValues());
            json = JsonWriter.writeEntity(entity);
            httpPatch = new HttpPatch(uri);
        }
        catch (JsonProcessingException | URISyntaxException ex) {
            throw new ServiceFailureException(ex);
        }
        LOGGER.debug("Patching: {}", (Object)httpPatch.getURI());
        httpPatch.setEntity((HttpEntity)new StringEntity(json, ContentType.APPLICATION_JSON));
        try (CloseableHttpResponse response = this.service.execute((HttpRequestBase)httpPatch);){
            Utils.throwIfNotOk((HttpRequestBase)httpPatch, response);
            EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
        }
        catch (IOException ex) {
            throw new ServiceFailureException(ex);
        }
    }

    @Override
    public void patch(Entity entity, List<JsonPatchOperation> patch) throws ServiceFailureException {
        HttpPatch httpPatch;
        String json;
        try {
            URI uri = this.buildUri(entity.getPrimaryKeyValues());
            json = JsonWriter.writeObject(patch);
            httpPatch = new HttpPatch(uri);
        }
        catch (JsonProcessingException | URISyntaxException ex) {
            throw new ServiceFailureException(ex);
        }
        LOGGER.debug("Patching: {} with patch {}", (Object)httpPatch.getURI(), patch);
        httpPatch.setEntity((HttpEntity)new StringEntity(json, APPLICATION_JSON_PATCH));
        try (CloseableHttpResponse response = this.service.execute((HttpRequestBase)httpPatch);){
            Utils.throwIfNotOk((HttpRequestBase)httpPatch, response);
            EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
        }
        catch (IOException ex) {
            throw new ServiceFailureException(ex);
        }
    }

    @Override
    public void delete(Entity entity) throws ServiceFailureException {
        HttpDelete httpDelete;
        try {
            URI uri = this.buildUri(entity.getPrimaryKeyValues());
            httpDelete = new HttpDelete(uri);
        }
        catch (URISyntaxException ex) {
            throw new ServiceFailureException(ex);
        }
        LOGGER.debug("Deleting: {}", (Object)httpDelete.getURI());
        try (CloseableHttpResponse response = this.service.execute((HttpRequestBase)httpDelete);){
            Utils.throwIfNotOk((HttpRequestBase)httpDelete, response);
            EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
        }
        catch (IOException ex) {
            throw new ServiceFailureException(ex);
        }
    }

    @Override
    public Query query() {
        if (this.parent == null) {
            return new Query(this.service, this.entityType);
        }
        return new Query(this.service, this.parent, this.navigationLink);
    }

    private URI buildUri(Object[] pkValues) throws NotImplementedException, URISyntaxException, ServiceFailureException {
        if (pkValues.length != 1) {
            throw new NotImplementedException("Multi-valued primary keys are not supported yet.");
        }
        URIBuilder uriBuilder = new URIBuilder(this.getSetPath() + "(" + ParserUtils.formatKeyValuesForUrl(pkValues[0]) + ")");
        URI uri = uriBuilder.build();
        return uri;
    }

    protected SensorThingsService getService() {
        return this.service;
    }
}

