/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostclient;

import com.github.fge.jsonpatch.JsonPatchOperation;
import de.fraunhofer.iosb.ilt.frostclient.Version;
import de.fraunhofer.iosb.ilt.frostclient.dao.BaseDao;
import de.fraunhofer.iosb.ilt.frostclient.dao.Dao;
import de.fraunhofer.iosb.ilt.frostclient.exception.ServiceFailureException;
import de.fraunhofer.iosb.ilt.frostclient.json.deserialize.JsonReader;
import de.fraunhofer.iosb.ilt.frostclient.model.Entity;
import de.fraunhofer.iosb.ilt.frostclient.model.EntityType;
import de.fraunhofer.iosb.ilt.frostclient.model.ModelRegistry;
import de.fraunhofer.iosb.ilt.frostclient.model.property.NavigationProperty;
import de.fraunhofer.iosb.ilt.frostclient.models.DataModel;
import de.fraunhofer.iosb.ilt.frostclient.query.Query;
import de.fraunhofer.iosb.ilt.frostclient.utils.ParserUtils;
import de.fraunhofer.iosb.ilt.frostclient.utils.TokenManager;
import de.fraunhofer.iosb.ilt.frostclient.utils.Utils;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpRequest;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SensorThingsService {
    private static final Logger LOGGER = LoggerFactory.getLogger(SensorThingsService.class);
    private final ModelRegistry modelRegistry;
    private final List<DataModel> models = new ArrayList<DataModel>();
    private JsonReader jsonReader;
    private URL endpoint;
    private String urlReplace;
    private HttpClientBuilder clientBuilder;
    private CloseableHttpClient httpClient;
    private TokenManager tokenManager;
    private Version version;
    private int requestTimeoutMs = 120000;

    public SensorThingsService(List<DataModel> models) {
        this.modelRegistry = new ModelRegistry();
        this.models.addAll(models);
    }

    private void initModels() {
        for (DataModel model : this.models) {
            model.init(this, this.modelRegistry);
        }
        this.modelRegistry.initFinalise();
        this.jsonReader = new JsonReader(this.modelRegistry);
    }

    public SensorThingsService(ModelRegistry modelRegistry) {
        this.modelRegistry = modelRegistry;
        modelRegistry.initFinalise();
        this.jsonReader = new JsonReader(modelRegistry);
    }

    public SensorThingsService(DataModel ... models) {
        this(Arrays.asList(models));
    }

    public SensorThingsService(URI endpoint, List<DataModel> models) throws MalformedURLException {
        this(models);
        this.setEndpoint(endpoint);
    }

    public SensorThingsService(URI endpoint, DataModel ... models) throws MalformedURLException {
        this(endpoint, Arrays.asList(models));
    }

    public SensorThingsService(URL endpoint, List<DataModel> models) throws MalformedURLException {
        this(models);
        this.setEndpoint(endpoint);
    }

    public SensorThingsService(URL endpoint, DataModel ... models) throws MalformedURLException {
        this(endpoint, Arrays.asList(models));
    }

    public ModelRegistry getModelRegistry() {
        return this.modelRegistry;
    }

    public <T extends DataModel> T getModel(Class<T> clazz) {
        return this.modelRegistry.getModel(clazz);
    }

    public <T extends DataModel> boolean hasModel(Class<T> clazz) {
        return this.modelRegistry.hasModel(clazz);
    }

    public JsonReader getJsonReader() {
        return this.jsonReader;
    }

    public final SensorThingsService setEndpoint(URI endpoint) throws MalformedURLException {
        return this.setEndpoint(endpoint.toURL());
    }

    public final SensorThingsService setEndpoint(URL endpoint) throws MalformedURLException {
        String lastSegment;
        Version detectedVersion;
        if (this.endpoint != null) {
            throw new IllegalStateException("endpoint URL already set.");
        }
        Object url = StringUtils.removeEnd((String)endpoint.toString(), (String)"/");
        this.endpoint = new URL((String)url + "/");
        if (this.models.isEmpty() && !this.modelRegistry.isInitialised()) {
            this.models.addAll(Utils.detectModels(this, endpoint));
        }
        if ((detectedVersion = Version.findVersion(lastSegment = ((String)url).substring(((String)url).lastIndexOf(47) + 1))) == null) {
            if (this.getVersion() == null) {
                throw new MalformedURLException("endpoint URL does not contain version (e.g. http://example.org/v1.0/) nor version information explicitely provided");
            }
            if (!((String)url).endsWith(this.getVersion().getUrlPart())) {
                url = (String)url + "/" + this.getVersion().getUrlPart();
                this.endpoint = new URL((String)url + "/");
            }
        } else {
            this.version = detectedVersion;
        }
        this.initModels();
        return this;
    }

    public final SensorThingsService setUrlReplace(String urlReplace) {
        this.urlReplace = urlReplace;
        return this;
    }

    public URL getEndpoint() {
        if (this.endpoint == null) {
            throw new IllegalStateException("endpoint URL not set.");
        }
        return this.endpoint;
    }

    public boolean isEndpointSet() {
        return this.endpoint != null;
    }

    public URL getFullPath(Entity parent, NavigationProperty relation) throws ServiceFailureException {
        try {
            return new URL(this.getEndpoint().toString() + ParserUtils.relationPath(parent, relation));
        }
        catch (MalformedURLException exc) {
            LOGGER.error("Failed to generate URL.", (Throwable)exc);
            throw new ServiceFailureException(exc);
        }
    }

    public URL getFullPath(EntityType entityType) throws ServiceFailureException {
        try {
            return new URL(this.getEndpoint().toString() + entityType.mainContainer);
        }
        catch (MalformedURLException exc) {
            LOGGER.error("Failed to generate URL.", (Throwable)exc);
            throw new ServiceFailureException(exc);
        }
    }

    public CloseableHttpResponse execute(HttpRequestBase request) throws IOException {
        String urlString = request.getURI().toString();
        if (this.urlReplace != null && urlString.startsWith(this.urlReplace)) {
            String newUrlString = this.endpoint.toString() + urlString.substring(this.urlReplace.length());
            LOGGER.debug("   Fixed: {}", (Object)newUrlString);
            try {
                request.setURI(new URI(newUrlString));
            }
            catch (URISyntaxException ex) {
                throw new IOException("Failed to replace start of URL", ex);
            }
        }
        CloseableHttpClient client = this.getHttpClient();
        this.setTimeouts(request);
        if (this.tokenManager != null) {
            this.tokenManager.addAuthHeader((HttpRequest)request);
        }
        return client.execute((HttpUriRequest)request);
    }

    private SensorThingsService setTimeouts(HttpRequestBase request) {
        RequestConfig.Builder configBuilder = request.getConfig() == null ? RequestConfig.copy((RequestConfig)RequestConfig.DEFAULT) : RequestConfig.copy((RequestConfig)request.getConfig());
        RequestConfig config = configBuilder.setSocketTimeout(this.requestTimeoutMs).setConnectTimeout(this.requestTimeoutMs).setConnectionRequestTimeout(this.requestTimeoutMs).build();
        request.setConfig(config);
        return this;
    }

    public Query query(EntityType type) {
        return new Query(this, type);
    }

    public Dao dao(EntityType type) {
        return new BaseDao(this, type);
    }

    public void create(Entity entity) throws ServiceFailureException {
        new BaseDao(this, entity.getEntityType()).create(entity);
    }

    public void update(Entity entity) throws ServiceFailureException {
        new BaseDao(this, entity.getEntityType()).update(entity);
    }

    public void patch(Entity entity, List<JsonPatchOperation> patch) throws ServiceFailureException {
        new BaseDao(this, entity.getEntityType()).patch(entity, patch);
    }

    public void delete(Entity entity) throws ServiceFailureException {
        new BaseDao(this, entity.getEntityType()).delete(entity);
    }

    public SensorThingsService setTokenManager(TokenManager tokenManager) {
        if (tokenManager != null && this.httpClient != null) {
            tokenManager.setHttpClient(this.httpClient);
        }
        this.tokenManager = tokenManager;
        return this;
    }

    public TokenManager getTokenManager() {
        return this.tokenManager;
    }

    public CloseableHttpClient getHttpClient() {
        if (this.httpClient == null) {
            this.httpClient = this.getClientBuilder().build();
            if (this.tokenManager != null) {
                this.tokenManager.setHttpClient(this.httpClient);
            }
        }
        return this.httpClient;
    }

    public HttpClientBuilder getClientBuilder() {
        if (this.clientBuilder == null) {
            this.clientBuilder = HttpClients.custom().useSystemProperties();
        }
        return this.clientBuilder;
    }

    public void rebuildHttpClient() {
        this.httpClient = null;
    }

    public List<DataModel> getModels() {
        return Collections.unmodifiableList(this.models);
    }

    public Version getVersion() {
        if (this.version == null) {
            for (DataModel model : this.models) {
                this.version = model.getVersion();
                if (this.version == null) continue;
                return this.version;
            }
        }
        return this.version;
    }

    public void setVersion(Version version) {
        this.version = version;
    }

    public int getRequestTimeoutMs() {
        return this.requestTimeoutMs;
    }

    public SensorThingsService setRequestTimeoutMs(int requestTimeoutMs) {
        this.requestTimeoutMs = requestTimeoutMs;
        return this;
    }
}

