/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.configurable.editor.swing;

import de.fraunhofer.iosb.ilt.configurable.ConfigEditor;
import de.fraunhofer.iosb.ilt.configurable.GuiFactorySwing;
import de.fraunhofer.iosb.ilt.configurable.editor.EditorList;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EtchedBorder;

public final class FactoryListSwing<U, T extends ConfigEditor<U>>
implements GuiFactorySwing {
    private final EditorList<U, T> parentEditor;
    private JPanel swComponent;
    private JPanel swListHolder;
    private JButton addButton;
    private boolean vertical = true;
    private String text = "Add item";

    public FactoryListSwing(EditorList<U, T> parentEditor, boolean vertical) {
        this.parentEditor = parentEditor;
        this.vertical = vertical;
        if (parentEditor.getMinCount() != parentEditor.getMaxCount()) {
            this.text = "Items:";
        }
    }

    public void setText(String text) {
        this.text = text;
    }

    @Override
    public JComponent getComponent() {
        if (this.swComponent == null) {
            this.createComponent();
        }
        return this.swComponent;
    }

    private void createComponent() {
        JPanel controls = new JPanel(new BorderLayout());
        controls.add((Component)new JLabel(this.text, 2), "Center");
        this.addButton = new JButton("+");
        this.addButton.addActionListener(event -> this.parentEditor.addItem());
        controls.add((Component)this.addButton, "West");
        this.swListHolder = new JPanel(new GridBagLayout());
        this.swComponent = new JPanel(new BorderLayout());
        this.swComponent.setBorder(new EtchedBorder());
        this.swComponent.add((Component)controls, "North");
        this.swComponent.add((Component)this.swListHolder, "Center");
        this.fillComponent();
    }

    public void fillComponent() {
        if (this.swComponent == null) {
            this.createComponent();
        }
        this.addButton.setVisible(this.parentEditor.canEdit());
        this.swListHolder.removeAll();
        if (this.parentEditor.getRawValue().isEmpty()) {
            this.swListHolder.add(new JLabel("No items added."));
        }
        int row = 0;
        Insets insets = new Insets(1, 1, 1, 1);
        for (ConfigEditor item : this.parentEditor.getRawValue()) {
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = this.vertical ? 0 : row;
            gbc.gridy = this.vertical ? row : 0;
            gbc.weightx = 1.0;
            gbc.fill = 2;
            gbc.insets = insets;
            this.swListHolder.add((Component)item.getGuiFactorySwing().getComponent(), gbc);
            if (this.parentEditor.canEdit()) {
                JButton removeButton = new JButton("\u274c");
                removeButton.setMargin(new Insets(1, 1, 1, 1));
                removeButton.addActionListener(event -> this.parentEditor.removeItem(item));
                gbc = new GridBagConstraints();
                gbc.gridx = this.vertical ? 1 : row;
                gbc.gridy = this.vertical ? row : 1;
                gbc.insets = insets;
                this.swListHolder.add((Component)removeButton, gbc);
            }
            ++row;
        }
        this.swListHolder.invalidate();
        this.swComponent.revalidate();
    }
}

