/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.configurable.editor.fx;

import de.fraunhofer.iosb.ilt.configurable.GuiFactoryFx;
import de.fraunhofer.iosb.ilt.configurable.editor.EditorDouble;
import java.math.BigDecimal;
import javafx.scene.Node;
import javafx.scene.control.TextField;
import javafx.scene.control.TextFormatter;
import javafx.scene.control.TextInputControl;
import javafx.util.converter.BigDecimalStringConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FactoryDoubleFx
implements GuiFactoryFx {
    private static final Logger LOGGER = LoggerFactory.getLogger(FactoryDoubleFx.class.getName());
    private final EditorDouble parentEditor;
    private TextInputControl fxNode;

    public FactoryDoubleFx(EditorDouble parentEditor) {
        this.parentEditor = parentEditor;
    }

    @Override
    public Node getNode() {
        if (this.fxNode == null) {
            this.createComponent();
        }
        return this.fxNode;
    }

    private void createComponent() {
        this.fxNode = new TextField();
        this.fxNode.setTextFormatter(new TextFormatter<BigDecimal>(new BigDecimalStringConverter()));
        this.fillComponent();
    }

    private double getRawValue() {
        Double rawValue = this.parentEditor.getRawValue();
        double min = this.parentEditor.getMin();
        double max = this.parentEditor.getMax();
        if (rawValue == null) {
            rawValue = 0.0;
            this.parentEditor.setRawValue(rawValue);
        }
        if (rawValue < min || rawValue > max) {
            rawValue = Math.max(min, Math.min(rawValue, max));
            this.parentEditor.setRawValue(rawValue);
        }
        return rawValue;
    }

    public void fillComponent() {
        double rawValue = this.getRawValue();
        this.fxNode.setText("" + rawValue);
    }

    public void readComponent() {
        if (this.fxNode != null) {
            try {
                this.parentEditor.setRawValue(Double.parseDouble(this.fxNode.getText()));
            }
            catch (NumberFormatException exc) {
                LOGGER.error("Failed to parse text to number: " + this.fxNode.getText());
            }
        }
    }
}

