/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.configurable.editor;

import com.google.gson.JsonElement;
import de.fraunhofer.iosb.ilt.configurable.ConfigEditor;
import de.fraunhofer.iosb.ilt.configurable.ConfigEditors;
import de.fraunhofer.iosb.ilt.configurable.Configurable;
import de.fraunhofer.iosb.ilt.configurable.ConfigurableFactory;
import de.fraunhofer.iosb.ilt.configurable.ConfigurationException;
import de.fraunhofer.iosb.ilt.configurable.GuiFactoryFx;
import de.fraunhofer.iosb.ilt.configurable.GuiFactorySwing;
import de.fraunhofer.iosb.ilt.configurable.JsonSchema.ItemRef;
import de.fraunhofer.iosb.ilt.configurable.JsonSchema.RootSchema;
import de.fraunhofer.iosb.ilt.configurable.JsonSchema.SchemaItem;
import de.fraunhofer.iosb.ilt.configurable.annotations.AnnotationHelper;
import de.fraunhofer.iosb.ilt.configurable.editor.EditorDefault;
import de.fraunhofer.iosb.ilt.configurable.editor.EditorString;
import de.fraunhofer.iosb.ilt.configurable.editor.fx.FactoryClassFx;
import de.fraunhofer.iosb.ilt.configurable.editor.swing.FactoryClassSwing;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EditorClass<C, D, T>
extends EditorDefault<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(EditorClass.class);
    private Class<T> clazz;
    private JsonElement classConfig;
    private ConfigEditor classEditor;
    private String profile = "default";
    private FactoryClassSwing factorySwing;
    private FactoryClassFx factoryFx;
    private C context;
    private D edtCtx;

    public EditorClass() {
    }

    public EditorClass(C context, D edtCtx, Class<T> clazz) {
        this.clazz = clazz;
        this.setContexts(context, edtCtx);
    }

    public EditorClass(C context, D edtCtx, Class<T> clazz, String label, String description) {
        this.clazz = clazz;
        this.setLabel(label);
        this.setDescription(description);
        this.setContexts(context, edtCtx);
    }

    @Override
    public void initFor(Field field) {
        EdOptsClass annotation = field.getAnnotation(EdOptsClass.class);
        if (annotation == null) {
            throw new IllegalArgumentException("Field must have an EdOptsClass annotation to use this editor: " + field.getName());
        }
        this.clazz = annotation.clazz();
    }

    public final void setContexts(C context, D edtCtx) {
        this.context = context;
        this.edtCtx = edtCtx;
    }

    @Override
    public void setConfig(JsonElement classConfig) {
        this.classConfig = classConfig;
        this.initClass();
    }

    @Override
    public JsonElement getConfig() {
        this.readComponent();
        return this.classConfig;
    }

    @Override
    public SchemaItem getJsonSchema(RootSchema rootSchema) {
        if (rootSchema == null) {
            return this.classEditor.getJsonSchema(rootSchema).setTitle(this.getLabel()).setDescription(this.getDescription());
        }
        String refName = this.clazz.getName();
        if (!rootSchema.hasDef(refName)) {
            rootSchema.addDef(refName, new ItemRef(refName));
            rootSchema.addDef(refName, this.classEditor.getJsonSchema(rootSchema));
        }
        return new ItemRef(refName);
    }

    @Override
    public GuiFactorySwing getGuiFactorySwing() {
        if (this.factoryFx != null) {
            throw new IllegalArgumentException("Can not mix different types of editors.");
        }
        if (this.factorySwing == null) {
            this.factorySwing = new FactoryClassSwing(this);
        }
        return this.factorySwing;
    }

    @Override
    public GuiFactoryFx getGuiFactoryFx() {
        if (this.factorySwing != null) {
            throw new IllegalArgumentException("Can not mix different types of editors.");
        }
        if (this.factoryFx == null) {
            this.factoryFx = new FactoryClassFx(this);
        }
        return this.factoryFx;
    }

    public void initClass() {
        this.classEditor = ConfigEditors.buildEditorFromClass(this.clazz, this.context, this.edtCtx).orElse(null);
        if (this.classEditor == null) {
            Object instance = null;
            try {
                instance = this.findFactory(this.context, this.edtCtx).instantiate(this.clazz, this.classConfig, this.context, this.edtCtx);
            }
            catch (ConfigurationException exc) {
                throw new RuntimeException(exc);
            }
            if (instance instanceof Configurable) {
                Configurable confInstance = instance;
                this.classEditor = confInstance.getConfigEditor(this.context, this.edtCtx);
            } else {
                LOGGER.warn("Class {} is not configurable.", (Object)this.clazz);
                this.classEditor = new EditorString("", 6);
            }
        }
        this.classEditor.setConfig(this.classConfig);
        this.classEditor.setProfile(this.profile);
        this.fillComponent();
    }

    private void fillComponent() {
        if (this.factorySwing != null) {
            this.factorySwing.fillComponent();
        }
        if (this.factoryFx != null) {
            this.factoryFx.fillComponent();
        }
    }

    public ConfigEditor getClassEditor() {
        return this.classEditor;
    }

    private void readComponent() {
        if (this.classEditor == null) {
            this.initClass();
        }
        if (this.classEditor != null) {
            this.classConfig = this.classEditor.getConfig();
        }
    }

    public void setClassConfig(JsonElement classConfig) {
        this.classConfig = classConfig;
    }

    public JsonElement getClassConfig() {
        return this.classConfig;
    }

    @Override
    public T getValue() throws ConfigurationException {
        this.readComponent();
        return this.tryToInstantiate();
    }

    private T tryToInstantiate() throws ConfigurationException {
        try {
            return this.instantiate();
        }
        catch (IllegalArgumentException | ReflectiveOperationException exc) {
            throw new ConfigurationException(exc);
        }
    }

    private T instantiate() throws ReflectiveOperationException, ConfigurationException, IllegalArgumentException {
        ConfigurableFactory factory = this.findFactory(this.context, this.edtCtx);
        Optional<Constructor<?>> configurableConstructor = AnnotationHelper.getConfigurableConstructor(this.clazz);
        if (configurableConstructor.isPresent()) {
            return AnnotationHelper.instantiateFrom(configurableConstructor.get(), this.classConfig, this.context, this.edtCtx);
        }
        return factory.instantiate(this.clazz, this.classConfig, this.context, this.edtCtx);
    }

    @Override
    public void setValue(T value) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setProfile(String profile) {
        this.profile = profile;
        if (this.classEditor != null) {
            this.classEditor.setProfile(profile);
        }
    }

    private ConfigurableFactory findFactory(C context, D edtCtx) {
        if (edtCtx instanceof ConfigurableFactory) {
            return (ConfigurableFactory)edtCtx;
        }
        if (context instanceof ConfigurableFactory) {
            return (ConfigurableFactory)context;
        }
        return new FactoryImp();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface EdOptsClass {
        public Class<?> clazz();
    }

    private class FactoryImp
    implements ConfigurableFactory {
        private FactoryImp() {
        }

        @Override
        public <T> T instantiate(Class<? extends T> clazz, JsonElement config, Object context, Object edtCtx) throws ConfigurationException {
            T newInstance;
            try {
                newInstance = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (ReflectiveOperationException | SecurityException exc) {
                throw new ConfigurationException(exc);
            }
            if (newInstance instanceof Configurable) {
                Configurable confInstance = (Configurable)newInstance;
                confInstance.configure(EditorClass.this.classConfig, context, edtCtx, null);
            }
            return newInstance;
        }

        @Override
        public Object instantiate(String className, JsonElement config, Object context, Object edtCtx) {
            throw new UnsupportedOperationException("Not supported.");
        }
    }
}

