/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.configurable.JsonSchema;

import de.fraunhofer.iosb.ilt.configurable.JsonSchema.SchemaItem;
import de.fraunhofer.iosb.ilt.configurable.JsonSchema.SchemaItemAbstract;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ItemObject
extends SchemaItemAbstract<ItemObject> {
    private Map<String, SchemaItem> properties;
    private boolean additionalProperties = false;
    private List<String> required;
    private List<String> defaultProperties;
    private List<SchemaItem> oneOf;

    public ItemObject() {
        super("object");
    }

    @Override
    public ItemObject getThis() {
        return this;
    }

    public boolean isAdditionalProperties() {
        return this.additionalProperties;
    }

    public ItemObject setAdditionalProperties(boolean additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    public Map<String, SchemaItem> getProperties() {
        return this.properties;
    }

    public ItemObject addProperty(String name, SchemaItem property) {
        if (this.properties == null) {
            this.properties = new HashMap<String, SchemaItem>();
        }
        this.properties.put(name, property);
        return this;
    }

    public ItemObject addProperty(String name, boolean isOptional, SchemaItem property) {
        if (this.properties == null) {
            this.properties = new HashMap<String, SchemaItem>();
        }
        this.properties.put(name, property);
        if (!isOptional) {
            this.addRequired(name);
            this.addDefaultProperty(name);
        }
        return this;
    }

    public void setProperties(Map<String, SchemaItem> properties) {
        this.properties = properties;
    }

    public List<String> getRequired() {
        if (this.required == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.required);
    }

    public ItemObject addRequired(String name) {
        if (this.required == null) {
            this.required = new ArrayList<String>();
        }
        this.required.add(name);
        return this;
    }

    public void setRequired(List<String> required) {
        this.required = required;
    }

    public List<SchemaItem> getOneOf() {
        return this.oneOf;
    }

    public void setOneOf(List<SchemaItem> oneOf) {
        this.oneOf = oneOf;
    }

    public List<String> getDefaultProperties() {
        if (this.defaultProperties == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.defaultProperties);
    }

    public ItemObject addDefaultProperty(String name) {
        if (this.defaultProperties == null) {
            this.defaultProperties = new ArrayList<String>();
        }
        this.defaultProperties.add(name);
        return this;
    }

    public void setDefaultProperties(List<String> defaultProperties) {
        this.defaultProperties = defaultProperties;
    }
}

