/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.configurableexample;

import com.google.gson.JsonElement;
import de.fraunhofer.iosb.ilt.configurable.annotations.ConfigurableConstructor;
import de.fraunhofer.iosb.ilt.configurable.annotations.ConfigurableField;
import de.fraunhofer.iosb.ilt.configurable.annotations.ConfigurableParameter;
import de.fraunhofer.iosb.ilt.configurable.editor.EditorDouble;
import de.fraunhofer.iosb.ilt.configurable.editor.EditorInt;
import de.fraunhofer.iosb.ilt.configurableexample.AbstractShape;
import de.fraunhofer.iosb.ilt.configurableexample.Flag;
import de.fraunhofer.iosb.ilt.configurableexample.Shape;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Flag.Internal
public class Circle
extends AbstractShape {
    private static final Logger LOGGER = LoggerFactory.getLogger(Circle.class);
    @ConfigurableField(editor=EditorDouble.class, label="X-Coordinate", description="The X-Coordinate of the centre of the circle.")
    @EditorDouble.EdOptsDouble(min=0.0, max=1000.0, step=0.1, dflt=10.0)
    private double x;
    @ConfigurableField(editor=EditorDouble.class, label="Y-Coordinate", description="The Y-Coordinate of the centre of the circle.")
    @EditorDouble.EdOptsDouble(min=0.0, max=1000.0, step=0.1, dflt=10.0)
    private double y;
    @ConfigurableField(editor=EditorInt.class, label="Radius", description="The radius of our circle")
    @EditorInt.EdOptsInt(min=1, max=100, step=1, dflt=10)
    private int r;

    @ConfigurableConstructor
    public Circle(@ConfigurableParameter(type=ConfigurableParameter.ConfigurableParameterType.RUNTIME_CONTEXT) Void runtimeContext, @ConfigurableParameter(type=ConfigurableParameter.ConfigurableParameterType.CLASS_CONFIG) JsonElement classConfig, @ConfigurableParameter(jsonField="shape") Shape nestedShape) {
        this.shape = nestedShape;
    }

    @Override
    public void paintMe() {
        LOGGER.info("I'm a circle at {}, {} with radius {}, color {}, and pattern {}!", new Object[]{this.x, this.y, this.r, this.getColor(), this.getPattern()});
        super.paintMe();
    }
}

