/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.configurableexample;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import de.fraunhofer.iosb.ilt.configurable.ConfigEditor;
import de.fraunhofer.iosb.ilt.configurable.ConfigEditors;
import de.fraunhofer.iosb.ilt.configurable.ConfigurationException;
import de.fraunhofer.iosb.ilt.configurableexample.FlagShapeList;
import java.net.URL;
import java.util.ResourceBundle;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.TextArea;
import javafx.scene.layout.BorderPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ControllerScene
implements Initializable {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)ControllerScene.class.getName());
    @FXML
    private BorderPane paneEditor;
    @FXML
    private TextArea textAreaOutput;
    private ConfigEditor editor;

    @FXML
    private void actionLoad(ActionEvent event) {
        this.loadConfig();
    }

    @FXML
    private void actionPrint(ActionEvent event) {
        this.printConfig();
    }

    @FXML
    private void actionWave(ActionEvent event) {
        this.useConfig();
    }

    private void addEditorToGui() {
        this.editor = (ConfigEditor)ConfigEditors.buildEditorFromClass(FlagShapeList.class, null, null).get();
        this.paneEditor.setCenter(this.editor.getGuiFactoryFx().getNode());
    }

    private void useConfig() {
        try {
            JsonElement config = this.editor.getConfig();
            FlagShapeList flag = new FlagShapeList();
            flag.configure(config, null, null, null);
            flag.wave();
        }
        catch (ConfigurationException ex) {
            LOGGER.error("Could not configure the flag!", (Throwable)ex);
        }
    }

    private void printConfig() {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        JsonElement config = this.editor.getConfig();
        String jsonString = gson.toJson(config);
        this.textAreaOutput.setText(jsonString);
        LOGGER.info("Our configuration is:\n{}", (Object)jsonString);
    }

    public void loadConfig() {
        this.loadConfig(this.textAreaOutput.getText());
    }

    public void loadConfig(String jsonString) {
        JsonElement config = new JsonParser().parse(jsonString);
        this.editor.setConfig(config);
    }

    public void initialize(URL url, ResourceBundle rb) {
        this.addEditorToGui();
    }
}

