/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.configurableexample;

import com.google.gson.JsonElement;
import de.fraunhofer.iosb.ilt.configurable.ConfigEditor;
import de.fraunhofer.iosb.ilt.configurable.Configurable;
import de.fraunhofer.iosb.ilt.configurable.ConfigurationException;
import de.fraunhofer.iosb.ilt.configurable.editor.EditorInt;
import de.fraunhofer.iosb.ilt.configurable.editor.EditorMap;
import de.fraunhofer.iosb.ilt.configurable.editor.EditorSubclass;
import de.fraunhofer.iosb.ilt.configurableexample.Shape;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlagShape
implements Configurable<Object, Object> {
    private static final Logger LOGGER = LoggerFactory.getLogger(FlagShape.class);
    private int width;
    private int height;
    private Shape shape;
    private EditorMap configEditor;
    private EditorInt editorWidth;
    private EditorInt editorHeight;
    private EditorSubclass<Object, Object, Shape> editorShape;

    public void wave() {
        LOGGER.info("I'm waving a flag of {} by {}. It has a shape:", (Object)this.width, (Object)this.height);
        this.shape.paintMe();
    }

    public void configure(JsonElement config, Object context, Object edtCtx, ConfigEditor<?> configEditor) throws ConfigurationException {
        this.getConfigEditor(context, edtCtx);
        configEditor.setConfig(config);
        this.width = this.editorWidth.getValue();
        this.height = this.editorHeight.getValue();
        this.shape = (Shape)this.editorShape.getValue();
    }

    public ConfigEditor<?> getConfigEditor(Object context, Object edtCtx) {
        if (this.configEditor == null) {
            this.configEditor = new EditorMap();
            this.editorWidth = new EditorInt(1, 100, 1, 10, "Width", "The width of our flag");
            this.configEditor.addOption("width", (ConfigEditor)this.editorWidth, false);
            this.editorHeight = new EditorInt(1, 100, 1, 10, "Height", "The height of our flag");
            this.configEditor.addOption("height", (ConfigEditor)this.editorHeight, false);
            this.editorShape = new EditorSubclass(context, edtCtx, Shape.class, "Shape", "The shape to put on the flag.");
            this.configEditor.addOption("shape", this.editorShape, false);
        }
        return this.configEditor;
    }
}

