/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.configurableexample;

import com.google.gson.JsonElement;
import de.fraunhofer.iosb.ilt.configurable.ConfigEditor;
import de.fraunhofer.iosb.ilt.configurable.editor.EditorDouble;
import de.fraunhofer.iosb.ilt.configurable.editor.EditorInt;
import de.fraunhofer.iosb.ilt.configurable.editor.EditorMap;
import de.fraunhofer.iosb.ilt.configurableexample.AbstractShape;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Triangle
extends AbstractShape {
    private static final Logger LOGGER = LoggerFactory.getLogger(Triangle.class);
    private double x;
    private double y;
    private int side;
    private EditorMap configEditor;
    private EditorInt editorSide;
    private EditorDouble editorX;
    private EditorDouble editorY;

    @Override
    public void paintMe() {
        LOGGER.info("I'm a triangle at {}, {} with side-length of {} and color {}!", this.x, this.y, this.side, this.getColor());
    }

    @Override
    public void configure(JsonElement config, Object context, Object edtCtx, ConfigEditor<?> configEditor) {
        super.configure(config, context, edtCtx, configEditor);
        this.side = this.editorSide.getValue();
        this.x = this.editorX.getValue();
        this.y = this.editorY.getValue();
    }

    @Override
    public EditorMap getConfigEditor(Object context, Object edtCtx) {
        if (this.configEditor == null) {
            this.configEditor = super.getConfigEditor(context, edtCtx);
            this.editorSide = new EditorInt(1, 100, 1, 10, "Side", "The length of a side of our triangle.");
            this.configEditor.addOption("side", this.editorSide, false);
            this.editorX = new EditorDouble(0.0, 1000.0, 0.1, 10.0, "X-Coordinate", "The X-Coordinate of the centre of the circle.");
            this.configEditor.addOption("x", this.editorX, true);
            this.editorY = new EditorDouble(0.0, 1000.0, 0.1, 10.0, "Y-Coordinate", "The Y-Coordinate of the centre of the circle.");
            this.configEditor.addOption("y", this.editorY, true);
        }
        return this.configEditor;
    }
}

