/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.configurableexample;

import com.google.gson.JsonElement;
import de.fraunhofer.iosb.ilt.configurable.ConfigEditor;
import de.fraunhofer.iosb.ilt.configurable.Configurable;
import de.fraunhofer.iosb.ilt.configurable.ConfigurationException;
import de.fraunhofer.iosb.ilt.configurable.EditorFactory;
import de.fraunhofer.iosb.ilt.configurable.editor.EditorInt;
import de.fraunhofer.iosb.ilt.configurable.editor.EditorList;
import de.fraunhofer.iosb.ilt.configurable.editor.EditorMap;
import de.fraunhofer.iosb.ilt.configurable.editor.EditorSubclass;
import de.fraunhofer.iosb.ilt.configurableexample.Shape;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlagShapeList
implements Configurable<Object, Object> {
    private static final Logger LOGGER = LoggerFactory.getLogger(FlagShapeList.class);
    private int width;
    private int height;
    private List<Shape> shapes;
    private EditorMap configEditor;
    private EditorInt editorWidth;
    private EditorInt editorHeight;
    private EditorList<Shape, EditorSubclass<Object, Object, Shape>> editorShapes;

    public void wave() {
        LOGGER.info("I'm waving a flag of {} by {}. It has shapes:", (Object)this.width, (Object)this.height);
        for (Shape shape : this.shapes) {
            shape.paintMe();
        }
    }

    @Override
    public void configure(JsonElement config, Object context, Object edtCtx, ConfigEditor<?> ignoredConfigEditor) throws ConfigurationException {
        this.getConfigEditor(context, edtCtx);
        this.configEditor.setConfig(config);
        this.width = this.editorWidth.getValue();
        this.height = this.editorHeight.getValue();
        this.shapes = this.editorShapes.getValue();
    }

    @Override
    public ConfigEditor<?> getConfigEditor(Object context, Object edtCtx) {
        if (this.configEditor == null) {
            this.configEditor = new EditorMap();
            this.editorWidth = new EditorInt(1, 100, 1, 10, "Width", "The width of our flag");
            this.configEditor.addOption("width", this.editorWidth, false);
            this.editorHeight = new EditorInt(1, 100, 1, 10, "Height", "The height of our flag");
            this.configEditor.addOption("height", this.editorHeight, false);
            EditorFactory<EditorSubclass> factory = () -> new EditorSubclass<Object, Object, Shape>(context, edtCtx, Shape.class, "Shape", "A shape to put on the flag.");
            this.editorShapes = new EditorList(factory, "Shapes", "The shapes to put on the flag");
            this.configEditor.addOption("shape", this.editorShapes, false);
        }
        return this.configEditor;
    }
}

