/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.configurableexample;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import de.fraunhofer.iosb.ilt.configurable.ConfigEditor;
import de.fraunhofer.iosb.ilt.configurable.ConfigurationException;
import de.fraunhofer.iosb.ilt.configurable.Reflection;
import de.fraunhofer.iosb.ilt.configurableexample.FlagShapeList;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExampleGui
extends JFrame {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExampleGui.class);
    private JTextArea jsonTextArea;
    private JButton jButton1;
    private JButton jButtonToJson;
    private JButton jButtonFromJson;
    private JPanel panelEditor;
    private ConfigEditor editor;

    public ExampleGui() {
        this.createGui();
    }

    private void createGui() {
        this.setDefaultCloseOperation(3);
        this.getContentPane().setLayout(new BorderLayout());
        JSplitPane splitPane1 = new JSplitPane();
        JScrollPane jScrollPane1 = new JScrollPane();
        this.jsonTextArea = new JTextArea();
        splitPane1.setOrientation(0);
        splitPane1.setResizeWeight(0.5);
        jScrollPane1.setViewportView(this.jsonTextArea);
        splitPane1.setBottomComponent(jScrollPane1);
        JPanel panelTop = new JPanel();
        panelTop.setLayout(new GridBagLayout());
        this.jButton1 = new JButton();
        this.jButtonToJson = new JButton();
        this.jButtonFromJson = new JButton();
        this.panelEditor = new JPanel();
        this.jButton1.setText("Wave");
        this.jButton1.addActionListener(e -> this.useConfig());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 0.01;
        panelTop.add((Component)this.jButton1, gridBagConstraints);
        this.jButtonToJson.setText("To JSON");
        this.jButtonToJson.addActionListener(e -> this.printConfig());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weightx = 0.01;
        panelTop.add((Component)this.jButtonToJson, gridBagConstraints);
        this.jButtonFromJson.setText("Load JSON");
        this.jButtonFromJson.addActionListener(e -> this.loadConfig());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.01;
        panelTop.add((Component)this.jButtonFromJson, gridBagConstraints);
        this.panelEditor.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.weightx = 0.01;
        gridBagConstraints.weighty = 0.01;
        gridBagConstraints.fill = 2;
        panelTop.add((Component)this.panelEditor, gridBagConstraints);
        this.addEditorToGui(this.panelEditor);
        splitPane1.setTopComponent(panelTop);
        this.getContentPane().add((Component)splitPane1, "Center");
        this.pack();
    }

    private void addEditorToGui(JPanel parentPanel) {
        FlagShapeList flag = new FlagShapeList();
        this.editor = flag.getConfigEditor((Object)null, (Object)null);
        this.panelEditor.add(this.editor.getGuiFactorySwing().getComponent());
    }

    private void useConfig() {
        try {
            JsonElement config = this.editor.getConfig();
            FlagShapeList flag = new FlagShapeList();
            flag.configure(config, (Object)null, (Object)null, (ConfigEditor<?>)null);
            flag.wave();
        }
        catch (ConfigurationException ex) {
            LOGGER.error("Could not configure the flag!", ex);
        }
    }

    private void printConfig() {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        JsonElement config = this.editor.getConfig();
        String jsonString = gson.toJson(config);
        this.jsonTextArea.setText(jsonString);
        LOGGER.info("Our configuration is:\n{}", (Object)jsonString);
    }

    public void loadConfig() {
        this.loadConfig(this.jsonTextArea.getText());
    }

    public void loadConfig(String jsonString) {
        JsonElement config = new JsonParser().parse(jsonString);
        this.editor.setConfig(config);
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(() -> {
            ExampleGui exampleGui = new ExampleGui();
            exampleGui.setVisible(true);
            exampleGui.setSize(400, 300);
        });
        new Thread(() -> Reflection.getReflections()).start();
    }
}

