/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.configurable.editor.fx;

import java.util.ArrayList;
import java.util.List;
import javafx.application.Platform;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.control.ComboBox;
import javafx.scene.control.TextField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilteringComboBox<E>
extends ComboBox<E> {
    private static final Logger LOGGER = LoggerFactory.getLogger(FilteringComboBox.class.getName());
    private final List<E> allElements;

    public FilteringComboBox(List<E> elements) {
        super(FXCollections.observableArrayList(elements));
        this.allElements = elements;
        this.setEditable(true);
        TextField textfield = this.getEditor();
        textfield.setOnKeyReleased(ke -> {
            if (ke.isControlDown()) {
                return;
            }
            switch (ke.getCode()) {
                case DOWN: 
                case UP: 
                case LEFT: 
                case RIGHT: 
                case KP_DOWN: 
                case KP_UP: 
                case KP_LEFT: 
                case KP_RIGHT: 
                case CONTROL: 
                case SHIFT: 
                case HOME: 
                case END: 
                case ENTER: {
                    return;
                }
            }
            Platform.runLater(() -> this.filterElements(textfield.getText().toLowerCase()));
        });
    }

    private void filterElements(String enteredText) {
        ArrayList<E> entriesFiltered = new ArrayList<E>();
        for (E entry : this.allElements) {
            if (!entry.toString().toLowerCase().contains(enteredText)) continue;
            entriesFiltered.add(entry);
        }
        if (entriesFiltered.size() > 0) {
            ObservableList items = this.getItems();
            if (items.size() == entriesFiltered.size()) {
                return;
            }
            items.clear();
            items.addAll(entriesFiltered);
            this.show();
        } else {
            this.hide();
        }
    }
}

