/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.configurable.editor.fx;

import de.fraunhofer.iosb.ilt.configurable.GuiFactoryFx;
import de.fraunhofer.iosb.ilt.configurable.editor.EditorInt;
import javafx.beans.property.Property;
import javafx.scene.Node;
import javafx.scene.control.Spinner;
import javafx.scene.control.SpinnerValueFactory;
import javafx.scene.control.TextFormatter;

public final class FactoryIntFx
implements GuiFactoryFx {
    private final EditorInt parentEditor;
    private Spinner<Integer> fxNode;
    private int min;

    public FactoryIntFx(EditorInt parentEditor) {
        this.parentEditor = parentEditor;
    }

    @Override
    public Node getNode() {
        if (this.fxNode == null) {
            this.createComponent();
        }
        return this.fxNode;
    }

    private void createComponent() {
        Integer value = this.parentEditor.getValue();
        this.min = this.parentEditor.getMin();
        if (value == null) {
            value = Math.max(0, this.min);
        }
        SpinnerValueFactory.IntegerSpinnerValueFactory factory = new SpinnerValueFactory.IntegerSpinnerValueFactory(this.min, this.parentEditor.getMax(), value.intValue(), this.parentEditor.getStep());
        this.fxNode = new Spinner((SpinnerValueFactory)factory);
        this.fxNode.setEditable(true);
        TextFormatter formatter = new TextFormatter(factory.getConverter(), factory.getValue());
        this.fxNode.getEditor().setTextFormatter(formatter);
        factory.valueProperty().bindBidirectional((Property)formatter.valueProperty());
        this.fillComponent();
    }

    public void fillComponent() {
        Integer rawValue = this.parentEditor.getRawValue();
        if (rawValue == null) {
            rawValue = Math.max(0, this.min);
        }
        this.fxNode.getValueFactory().setValue((Object)rawValue);
    }

    public void readComponent() {
        if (this.fxNode != null) {
            this.parentEditor.setRawValue((Integer)this.fxNode.getValue());
        }
    }
}

