/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.configurable.editor;

import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonPrimitive;
import de.fraunhofer.iosb.ilt.configurable.GuiFactoryFx;
import de.fraunhofer.iosb.ilt.configurable.GuiFactorySwing;
import de.fraunhofer.iosb.ilt.configurable.JsonSchema.ItemNumber;
import de.fraunhofer.iosb.ilt.configurable.JsonSchema.RootSchema;
import de.fraunhofer.iosb.ilt.configurable.JsonSchema.SchemaItem;
import de.fraunhofer.iosb.ilt.configurable.annotations.AnnotationHelper;
import de.fraunhofer.iosb.ilt.configurable.editor.EditorDefault;
import de.fraunhofer.iosb.ilt.configurable.editor.fx.FactoryDoubleFx;
import de.fraunhofer.iosb.ilt.configurable.editor.swing.FactoryDoubleSwing;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EditorDouble
extends EditorDefault<Double> {
    private static final Logger LOGGER = LoggerFactory.getLogger(EditorDouble.class.getName());
    private double min;
    private double max;
    private double step;
    private Double dflt;
    private Double value;
    public Set<String> profilesEdit = AnnotationHelper.csvToReadOnlySet("");
    private String profile = "default";
    private FactoryDoubleSwing factorySwing;
    private FactoryDoubleFx factoryFx;

    public EditorDouble() {
    }

    public EditorDouble(double min, double max, double step, double deflt) {
        this.dflt = deflt;
        this.value = deflt;
        this.min = min;
        this.max = max;
        this.step = step;
    }

    public EditorDouble(double min, double max, double step, double deflt, String label, String description) {
        this.dflt = deflt;
        this.value = deflt;
        this.min = min;
        this.max = max;
        this.step = step;
        this.setLabel(label);
        this.setDescription(description);
    }

    @Override
    public void initFor(Field field) {
        EdOptsDouble annotation = field.getAnnotation(EdOptsDouble.class);
        if (annotation == null) {
            throw new IllegalArgumentException("Field must have an EdOptsDouble annotation to use this editor: " + field.getName());
        }
        this.min = annotation.min();
        this.max = annotation.max();
        this.step = annotation.step();
        boolean isPrimitive = field.getType().isPrimitive();
        boolean dfltIsNull = annotation.dfltIsNull();
        if (dfltIsNull) {
            if (isPrimitive) {
                LOGGER.error("Flag dfltIsNull set to true on a primitive field: {}", (Object)field);
                this.dflt = 0.0;
            }
        } else {
            this.dflt = annotation.dflt();
        }
        this.value = this.dflt;
        this.profilesEdit = AnnotationHelper.csvToReadOnlySet(annotation.profilesEdit());
    }

    @Override
    public void setConfig(JsonElement config) {
        this.value = config != null && config.isJsonPrimitive() ? Double.valueOf(config.getAsDouble()) : this.dflt;
        this.fillComponent();
    }

    @Override
    public JsonElement getConfig() {
        Double val = this.getValue();
        if (val == null) {
            return JsonNull.INSTANCE;
        }
        return new JsonPrimitive(val);
    }

    @Override
    public SchemaItem getJsonSchema(RootSchema rootSchema) {
        ItemNumber item = (ItemNumber)((ItemNumber)((ItemNumber)new ItemNumber().setDeflt(this.dflt)).setTitle(this.getLabel())).setDescription(this.getDescription());
        if (this.min > Double.NEGATIVE_INFINITY) {
            item.setMinimum(BigDecimal.valueOf(this.min));
        }
        if (this.max < Double.POSITIVE_INFINITY) {
            item.setMaximum(BigDecimal.valueOf(this.max));
        }
        if (rootSchema == null) {
            return new RootSchema(item);
        }
        return item;
    }

    @Override
    public GuiFactorySwing getGuiFactorySwing() {
        if (this.factoryFx != null) {
            throw new IllegalArgumentException("Can not mix different types of editors.");
        }
        if (this.factorySwing == null) {
            this.factorySwing = new FactoryDoubleSwing(this);
        }
        return this.factorySwing;
    }

    @Override
    public GuiFactoryFx getGuiFactoryFx() {
        if (this.factorySwing != null) {
            throw new IllegalArgumentException("Can not mix different types of editors.");
        }
        if (this.factoryFx == null) {
            this.factoryFx = new FactoryDoubleFx(this);
        }
        return this.factoryFx;
    }

    private void fillComponent() {
        if (this.factorySwing != null) {
            this.factorySwing.fillComponent();
        }
        if (this.factoryFx != null) {
            this.factoryFx.fillComponent();
        }
    }

    private void readComponent() {
        if (this.factorySwing != null) {
            this.factorySwing.readComponent();
        }
        if (this.factoryFx != null) {
            this.factoryFx.readComponent();
        }
    }

    public double getMin() {
        return this.min;
    }

    public double getMax() {
        return this.max;
    }

    public Double getDeflt() {
        return this.dflt;
    }

    public double getStep() {
        return this.step;
    }

    public Double getRawValue() {
        return this.value;
    }

    public void setRawValue(double value) {
        if (value < this.min) {
            value = this.min;
        }
        if (value > this.max) {
            value = this.max;
        }
        this.value = value;
    }

    @Override
    public Double getValue() {
        this.readComponent();
        if (this.value == null) {
            return null;
        }
        if (this.value > this.max) {
            this.value = this.max;
        }
        if (this.value < this.min) {
            this.value = this.min;
        }
        return this.value;
    }

    @Override
    public void setValue(Double value) {
        this.value = value;
        this.fillComponent();
    }

    @Override
    public void setProfile(String profile) {
        this.profile = profile;
        this.fillComponent();
    }

    public void setProfilesEdit(String csv) {
        this.profilesEdit = AnnotationHelper.csvToReadOnlySet(csv);
    }

    @Override
    public boolean canEdit() {
        return this.profilesEdit.contains(this.profile);
    }

    @Override
    public boolean isDefault() {
        this.readComponent();
        return this.dflt == this.value;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface EdOptsDouble {
        public double min() default -Infinity;

        public double max() default Infinity;

        public double step() default 4.9E-324;

        public double dflt() default 0.0;

        public boolean dfltIsNull() default false;

        public String profilesEdit() default "";
    }
}

