/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.configurableexample;

import com.google.gson.JsonElement;
import de.fraunhofer.iosb.ilt.configurable.ConfigEditor;
import de.fraunhofer.iosb.ilt.configurable.editor.EditorDouble;
import de.fraunhofer.iosb.ilt.configurable.editor.EditorInt;
import de.fraunhofer.iosb.ilt.configurable.editor.EditorMap;
import de.fraunhofer.iosb.ilt.configurableexample.AbstractShape;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Circle
extends AbstractShape {
    private static final Logger LOGGER = LoggerFactory.getLogger(Circle.class);
    private double x;
    private double y;
    private int r;
    private EditorMap configEditor;
    private EditorInt editorR;
    private EditorDouble editorX;
    private EditorDouble editorY;

    @Override
    public void paintMe() {
        LOGGER.info("I'm a circle at {}, {} with radius {} and color {}!", new Object[]{this.x, this.y, this.r, this.getColor()});
    }

    @Override
    public void configure(JsonElement config, Object context, Object edtCtx, ConfigEditor<?> configEditor) {
        super.configure(config, context, edtCtx, configEditor);
        this.r = this.editorR.getValue();
        this.x = this.editorX.getValue();
        this.y = this.editorY.getValue();
    }

    @Override
    public EditorMap getConfigEditor(Object context, Object edtCtx) {
        if (this.configEditor == null) {
            this.configEditor = super.getConfigEditor(context, edtCtx);
            this.editorR = new EditorInt(1, 100, 1, 10, "Radius", "The radius of our circle");
            this.configEditor.addOption("r", (ConfigEditor)this.editorR, false);
            this.editorX = new EditorDouble(0.0, 1000.0, 0.1, 10.0, "X-Coordinate", "The X-Coordinate of the centre of the circle.");
            this.configEditor.addOption("x", (ConfigEditor)this.editorX, true);
            this.editorY = new EditorDouble(0.0, 1000.0, 0.1, 10.0, "Y-Coordinate", "The Y-Coordinate of the centre of the circle.");
            this.configEditor.addOption("y", (ConfigEditor)this.editorY, true);
        }
        return this.configEditor;
    }
}

