/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iese.ind2uce.registry;

import de.fraunhofer.iese.ind2uce.api.component.description.MethodInterfaceDescription;
import de.fraunhofer.iese.ind2uce.api.component.identifier.ComponentId;
import de.fraunhofer.iese.ind2uce.api.component.identifier.EnforcementScopeId;
import de.fraunhofer.iese.ind2uce.connectors.ConnectorFactory;
import de.fraunhofer.iese.ind2uce.connectors.OAuthCredentials;
import de.fraunhofer.iese.ind2uce.registry.ComponentType;
import de.fraunhofer.iese.ind2uce.registry.InterfaceDescriptionDiscovery;
import de.fraunhofer.iese.ind2uce.registry.RegistryBuilder;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComponentRegistry {
    private static final Logger LOG = LoggerFactory.getLogger(ComponentRegistry.class);
    private final RegistryBuilder registryBuilder;
    private final InterfaceDescriptionDiscovery discovery = new InterfaceDescriptionDiscovery();
    private final ComponentType type;
    private EnforcementScopeId enforcementScopeId;

    public ComponentRegistry(ComponentType type, URI pmpUrl, OAuthCredentials credentials) {
        this.type = type;
        this.registryBuilder = new RegistryBuilder(type, ConnectorFactory.getPmpClient((URI)pmpUrl, (OAuthCredentials)credentials));
    }

    public Map<MethodInterfaceDescription, Method> addService(Object componentService) {
        Map<MethodInterfaceDescription, Method> interfaceDescriptions = this.createInterfaceDescriptions(componentService);
        this.registryBuilder.addAll(interfaceDescriptions.keySet());
        return interfaceDescriptions;
    }

    public ComponentRegistry componentId(ComponentId componentId) {
        this.registryBuilder.componentId(componentId);
        return this;
    }

    public ComponentRegistry componentId(String componentId) {
        this.registryBuilder.componentId(componentId);
        return this;
    }

    private Map<MethodInterfaceDescription, Method> createInterfaceDescriptions(Object service) {
        return this.discovery.discover(service.getClass(), this.type, this.enforcementScopeId);
    }

    public ComponentRegistry enforcementScopeId(EnforcementScopeId enforcementScopeId) {
        this.enforcementScopeId = enforcementScopeId;
        return this;
    }

    public boolean register() {
        try {
            LOG.trace("Registering at PMP " + (Object)((Object)this.type));
            return this.registryBuilder.register();
        }
        catch (Exception e) {
            LOG.warn("Component could not be registered. " + (Object)((Object)this.type), (Throwable)e);
            return false;
        }
    }

    public String toString() {
        return "ComponentRegistry{type=" + (Object)((Object)this.type) + '}';
    }

    public ComponentRegistry url(String url) {
        this.registryBuilder.addUri(url);
        return this;
    }
}

