/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iese.ind2uce.reactive;

import de.fraunhofer.iese.ind2uce.api.component.exception.EvaluationUndecidableException;
import de.fraunhofer.iese.ind2uce.api.component.exception.InhibitException;
import de.fraunhofer.iese.ind2uce.api.component.interfaces.IPolicyEnforcementPoint;
import de.fraunhofer.iese.ind2uce.api.policy.AuthorizationDecision;
import de.fraunhofer.iese.ind2uce.api.policy.Event;
import de.fraunhofer.iese.ind2uce.pep.PolicyEnforcementPoint;
import de.fraunhofer.iese.ind2uce.reactive.AbstractRxPEP;
import de.fraunhofer.iese.ind2uce.reactive.common.RxPEPState;
import java.io.IOException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.concurrent.Callable;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import rx.Observable;
import rx.schedulers.Schedulers;

@ThreadSafe
public class ReactivePEP<T>
extends AbstractRxPEP<T> {
    private static final int MAX_RETRIES = 3;

    public ReactivePEP(Class<T> descriptionInterface, PolicyEnforcementPoint policyEnforcementPoint) {
        super(policyEnforcementPoint, descriptionInterface);
    }

    @Override
    public IPolicyEnforcementPoint getPolicyEnforcementPoint() {
        if (this.isReady() != RxPEPState.REGISTRATION_DONE_SUCCESSFULLY) {
            throw new IllegalStateException("Enforcement point is not yet registered at PMP");
        }
        return this.policyEnforcementPoint;
    }

    @Override
    protected Object enforceDecision(Method method, Object[] args) {
        Type returnType = method.getGenericReturnType();
        if (method.getReturnType() == Observable.class && returnType instanceof ParameterizedType) {
            Type genericType = ((ParameterizedType)returnType).getActualTypeArguments()[0];
            if (genericType == Event.class) {
                return this.enforceMethodForEvent(method, args);
            }
            if (genericType instanceof ParameterizedType && ((ParameterizedType)genericType).getRawType() == Pair.class && ((ParameterizedType)genericType).getActualTypeArguments().length == 2 && ((ParameterizedType)genericType).getActualTypeArguments()[0] == Event.class && ((ParameterizedType)genericType).getActualTypeArguments()[1] == AuthorizationDecision.class) {
                return this.getAuthorizationDecisionforEvent(method, args);
            }
        }
        throw new IllegalStateException("Unknown error happened due to illegal declaration in ");
    }

    private Observable<Event> enforceMethodForEvent(final Method method, final Object[] objects) {
        return Observable.fromCallable((Callable)new Callable<Event>(){

            @Override
            public Event call() throws InhibitException, EvaluationUndecidableException, IOException {
                Event event = ReactivePEP.this.readAndCreateEvent(method, objects);
                ReactivePEP.this.policyEnforcementPoint.enforce(event);
                return event;
            }
        }).doOnError(throwable -> Observable.error((Throwable)throwable));
    }

    private Observable<ImmutablePair<Event, AuthorizationDecision>> getAuthorizationDecisionforEvent(Method method, Object[] objects) {
        return Observable.fromCallable(() -> {
            Event event = this.readAndCreateEvent(method, objects);
            return new ImmutablePair((Object)event, (Object)this.policyEnforcementPoint.getDecision(event));
        }).subscribeOn(Schedulers.io());
    }

    @Override
    protected void postSuccessfulRegistration() {
    }
}

