/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iese.ind2uce.pep.modifiermethods;

import de.fraunhofer.iese.ind2uce.api.policy.parameter.ParameterList;
import de.fraunhofer.iese.ind2uce.pep.common.PrimitiveModifierMethod;
import de.fraunhofer.iese.ind2uce.registry.ActionDescription;
import de.fraunhofer.iese.ind2uce.registry.ActionParameterDescription;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;

public class ShortenInitialModifierMethod
extends PrimitiveModifierMethod {
    @Override
    public String getDisplayName() {
        return "shorten";
    }

    @Override
    public Object doModification(Object currentObject, ParameterList modifierMethodParameterList) {
        Object suffix = modifierMethodParameterList.getParameterValueForName("suffix");
        String suffixParam = suffix != null ? suffix.toString() : ".";
        Object caseTo = modifierMethodParameterList.getParameterValueForName("case");
        String caseToParam = caseTo != null ? caseTo.toString() : "upper";
        return this.shorten(currentObject.toString(), suffixParam, caseToParam);
    }

    @ActionDescription(description="Shorten a string to the first letter, change the case (per default to uppercase) and append a character (per default a point)", pepSupportedType=String.class)
    public String shorten(String name, @ActionParameterDescription(name="suffixParam", description="suffix to be set", mandatory=true, type=String.class) String suffixParam, @ActionParameterDescription(name="caseToParam", description="case change", mandatory=true, type=String.class) String caseToParam) {
        if (name == null) {
            return null;
        }
        String trimmed = name.trim();
        if (!StringUtils.isEmpty((CharSequence)trimmed)) {
            if (caseToParam.equalsIgnoreCase("upper")) {
                return trimmed.substring(0, 1).toUpperCase(Locale.ROOT) + suffixParam;
            }
            return trimmed.substring(0, 1).toLowerCase(Locale.ROOT) + suffixParam;
        }
        return name;
    }
}

