/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iese.ind2uce.pep.modifiermethods;

import de.fraunhofer.iese.ind2uce.api.policy.parameter.ParameterList;
import de.fraunhofer.iese.ind2uce.pep.common.PrimitiveModifierMethod;
import de.fraunhofer.iese.ind2uce.registry.ActionDescription;
import de.fraunhofer.iese.ind2uce.registry.ActionParameterDescription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class RangeModifierMethod
extends PrimitiveModifierMethod {
    private static Logger LOG = LoggerFactory.getLogger(RangeModifierMethod.class);

    @Override
    public Object doModification(Object currentObject, ParameterList modifierMethodParameterList) {
        Object pivot = modifierMethodParameterList.getParameterValueForName("pivot");
        int pivotParam = pivot != null ? (int)Math.round(Double.parseDouble(String.valueOf(pivot))) : 0;
        return this.range(currentObject.toString(), pivotParam);
    }

    @ActionDescription(description="finds the range of the given number", pepSupportedType=String.class)
    public String range(String inputString, @ActionParameterDescription(name="pivot", description="The value which measures the requested range", mandatory=true, type=Integer.class) int pivot) {
        if (StringUtils.isEmpty((Object)inputString)) {
            return inputString;
        }
        String result = "";
        if (inputString.contains(".")) {
            float upbound;
            float givenFloat = Float.parseFloat(String.valueOf(inputString));
            for (upbound = 0.0f; upbound < givenFloat; upbound += (float)pivot) {
            }
            float down = upbound - (float)pivot;
            result = down + "-" + upbound;
        } else {
            int upbound;
            int givenInt = Integer.parseInt(String.valueOf(inputString));
            for (upbound = 0; upbound < givenInt; upbound += pivot) {
            }
            int down = upbound - pivot;
            result = down + "-" + upbound;
        }
        LOG.trace("Built range {}% of {} --> {}", new Object[]{pivot, inputString, result});
        return result;
    }

    @Override
    public String getDisplayName() {
        return "range";
    }
}

