/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iese.ind2uce.pep.modifiermethods;

import de.fraunhofer.iese.ind2uce.api.policy.parameter.ParameterList;
import de.fraunhofer.iese.ind2uce.pep.common.PrimitiveModifierMethod;
import de.fraunhofer.iese.ind2uce.registry.ActionDescription;
import de.fraunhofer.iese.ind2uce.registry.ActionParameterDescription;

public class MultiplyModifierMethod
extends PrimitiveModifierMethod {
    @Override
    public String getDisplayName() {
        return "multiply";
    }

    @Override
    public Object doModification(Object currentObject, ParameterList modifierMethodParameterList) {
        Object operandObj = modifierMethodParameterList.getParameterValueForName("operand");
        Number result = null;
        if (currentObject instanceof Integer) {
            result = this.multiply((Integer)currentObject, Double.valueOf(String.valueOf(operandObj))).intValue();
        }
        if (currentObject instanceof Long) {
            result = this.multiply((Long)currentObject, Double.valueOf(String.valueOf(operandObj))).longValue();
        }
        if (currentObject instanceof Float) {
            result = Float.valueOf(this.multiply((Float)currentObject, Double.valueOf(String.valueOf(operandObj))).floatValue());
        }
        if (currentObject instanceof Double) {
            result = this.multiply((Double)currentObject, Double.valueOf(String.valueOf(operandObj))).doubleValue();
        }
        return result;
    }

    @ActionDescription(description="Multiplies two numbers", pepSupportedType=Number.class)
    public Number multiply(Number currentNumber, @ActionParameterDescription(name="operand", description="Number to be multiplied", mandatory=true) Number operand) {
        return currentNumber.doubleValue() * operand.doubleValue();
    }
}

