/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iese.ind2uce.pep.modifiermethods;

import de.fraunhofer.iese.ind2uce.api.policy.parameter.ParameterList;
import de.fraunhofer.iese.ind2uce.pep.common.PrimitiveModifierMethod;
import de.fraunhofer.iese.ind2uce.registry.ActionDescription;
import de.fraunhofer.iese.ind2uce.registry.ActionParameterDescription;
import org.apache.commons.codec.digest.DigestUtils;

public class HashModifierMethod
extends PrimitiveModifierMethod {
    @Override
    public Object doModification(Object currentObject, ParameterList modifierMethodParameterList) {
        if (currentObject == null) {
            return null;
        }
        String algorithm = (String)modifierMethodParameterList.getParameterValue("algorithm", String.class);
        return this.hash(currentObject.toString(), algorithm);
    }

    @ActionDescription(description="Replaces the string", pepSupportedType=Object.class)
    public Object hash(String currentObject, @ActionParameterDescription(name="algorithm", description="Hashing algorithm. Supported: SHA256 (default), MD5, SHA1", mandatory=false, type=String.class) String algorithm) {
        if (algorithm != null && "md5".equalsIgnoreCase(algorithm)) {
            return DigestUtils.md5Hex((String)currentObject);
        }
        if (algorithm != null && "sha1".equalsIgnoreCase(algorithm)) {
            return DigestUtils.sha1Hex((String)currentObject);
        }
        return DigestUtils.sha256Hex((String)currentObject);
    }

    @Override
    public String getDisplayName() {
        return "hash";
    }
}

