/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iese.ind2uce.pep.modifiermethods;

import de.fraunhofer.iese.ind2uce.api.policy.parameter.ParameterList;
import de.fraunhofer.iese.ind2uce.pep.common.PrimitiveModifierMethod;
import de.fraunhofer.iese.ind2uce.registry.ActionDescription;
import de.fraunhofer.iese.ind2uce.registry.ActionParameterDescription;

public class DivideModifierMethod
extends PrimitiveModifierMethod {
    @Override
    public String getDisplayName() {
        return "divide";
    }

    @Override
    public Object doModification(Object currentObject, ParameterList modifierMethodParameterList) {
        Object numeratorObj = modifierMethodParameterList.getParameterValueForName("numerator");
        Object denominatorObj = modifierMethodParameterList.getParameterValueForName("denominator");
        Double numerator = numeratorObj == null ? null : Double.valueOf(String.valueOf(numeratorObj));
        Double denominator = denominatorObj == null ? null : Double.valueOf(String.valueOf(denominatorObj));
        Number result = null;
        if (currentObject instanceof Integer) {
            result = this.divide(Integer.valueOf(String.valueOf(currentObject)), numerator, denominator).intValue();
        }
        if (currentObject instanceof Long) {
            result = this.divide(Long.valueOf(String.valueOf(currentObject)), numerator, denominator).longValue();
        }
        if (currentObject instanceof Float) {
            result = Float.valueOf(this.divide(Float.valueOf(String.valueOf(currentObject)), numerator, denominator).floatValue());
        }
        if (currentObject instanceof Double) {
            result = this.divide(Double.valueOf(String.valueOf(currentObject)), numerator, denominator).doubleValue();
        }
        return result;
    }

    @ActionDescription(description="Divides the target by the denominator or divides the numerator by the target. If both are present, replaces the target by the result.If none are present, returns the unmodified target.", pepSupportedType=Number.class)
    public Number divide(Number currentNumber, @ActionParameterDescription(name="numerator", description="Number to be divided", mandatory=false) Number numerator, @ActionParameterDescription(name="denominator", description="Number to divide by", mandatory=false) Number denominator) {
        if (numerator == null && denominator != null) {
            return this.div(currentNumber.doubleValue(), denominator.doubleValue());
        }
        if (numerator != null && denominator == null) {
            return this.div(numerator.doubleValue(), currentNumber.doubleValue());
        }
        if (numerator != null && denominator != null) {
            return this.div(numerator.doubleValue(), denominator.doubleValue());
        }
        return currentNumber;
    }

    private double div(double a, double b) {
        if (b == 0.0) {
            throw new IllegalArgumentException("Argument denominator is 0");
        }
        return a / b;
    }
}

