/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iese.ind2uce.pep.modifiermethods;

import de.fraunhofer.iese.ind2uce.api.policy.parameter.ParameterList;
import de.fraunhofer.iese.ind2uce.pep.common.PrimitiveModifierMethod;
import de.fraunhofer.iese.ind2uce.registry.ActionDescription;
import de.fraunhofer.iese.ind2uce.registry.ActionParameterDescription;
import java.util.Random;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnagramModifierMethod
extends PrimitiveModifierMethod {
    private static Logger LOG = LoggerFactory.getLogger(AnagramModifierMethod.class);

    @Override
    public String getDisplayName() {
        return "anagram";
    }

    @Override
    public Object doModification(Object currentObject, ParameterList modifierMethodParameterList) {
        Object percentage = modifierMethodParameterList.getParameterValueForName("percentage");
        int percentageParam = percentage != null ? (int)Math.round(Double.parseDouble(String.valueOf(percentage))) : 0;
        return this.anagram(currentObject.toString(), percentageParam);
    }

    @ActionDescription(description="Jumbles up the letters of the word so string does not make any sense", pepSupportedType=String.class)
    public String anagram(String inputString, @ActionParameterDescription(name="percentage", description="percentage of String to be modified (value between 0 and 100)", mandatory=true, type=Integer.class) int percentage) {
        if (inputString == null || inputString.length() <= 2) {
            return inputString;
        }
        boolean canBeScrambled = false;
        for (int i = 1; i < inputString.length(); ++i) {
            char c = inputString.charAt(i);
            if (c == inputString.charAt(0)) continue;
            canBeScrambled = true;
            break;
        }
        if (!canBeScrambled) {
            return inputString;
        }
        Random random = new Random();
        char[] a = inputString.toCharArray();
        int limit = Math.round((float)a.length * ((float)Math.min(percentage, 100) / 100.0f));
        for (int i = 0; i < Math.min(a.length - 1, limit); ++i) {
            int j = random.nextInt(Math.min(a.length - 1, limit));
            char temp = a[i];
            a[i] = a[j];
            a[j] = temp;
        }
        String result = new String(a);
        if (result.equals(inputString)) {
            result = this.anagram(inputString, percentage);
        }
        LOG.trace("Built anagram {}% of {} --> {}", new Object[]{percentage, inputString, result});
        return result;
    }
}

