/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iese.ind2uce.pep.common;

import java.util.Optional;

public class SubstringUtil {
    static final String BOTH_ARE_SET = "0";
    static final String END_NOT_SET = "1";
    static final String START_NOT_SET = "2";
    static final String BOTH_NOT_SET = "3";

    public static String substring(String s, int start, int end, String fillString, boolean autoFill) {
        String valueCheck = SubstringUtil.getValueCheck(s, start, end);
        int fixedEnd = SubstringUtil.fixEnd(s, end);
        String fixedFill = SubstringUtil.fixFill(fillString);
        switch (valueCheck) {
            case "0": {
                return SubstringUtil.substringChecked(s, start, fixedEnd, fixedFill, autoFill);
            }
            case "1": {
                return SubstringUtil.substringFrom(s, start, fixedFill, autoFill);
            }
            case "2": {
                return SubstringUtil.substringTo(s, fixedEnd, fixedFill, autoFill);
            }
            case "3": {
                return s;
            }
        }
        return "";
    }

    private static int fixEnd(String s, int end) {
        if (end > s.length()) {
            return s.length();
        }
        return end;
    }

    private static String fixFill(String fillString) {
        if (null == fillString) {
            return "";
        }
        return fillString;
    }

    private static String substringTo(String s, int signedEnd, String fillString, boolean autoFill) {
        if (!SubstringUtil.isNegative(signedEnd)) {
            return SubstringUtil.fillSuffix(s.substring(0, signedEnd), fillString, autoFill, s.length());
        }
        if (!SubstringUtil.isNegative(s.length() + signedEnd)) {
            return SubstringUtil.fillSuffix(s.substring(0, s.length() + signedEnd), fillString, autoFill, s.length());
        }
        return SubstringUtil.fillSuffix("", fillString, autoFill, s.length());
    }

    private static String substringFrom(String s, int signedStart, String fillString, boolean autoFill) {
        if (!SubstringUtil.isNegative(signedStart)) {
            return SubstringUtil.fillPrefix(s.substring(signedStart), fillString, autoFill, s.length());
        }
        if (!SubstringUtil.isNegative(s.length() + signedStart)) {
            return SubstringUtil.fillPrefix(s.substring(s.length() + signedStart), fillString, autoFill, s.length());
        }
        return "";
    }

    private static String getValueCheck(String s, int start, int end) {
        if (Optional.ofNullable(s).isPresent()) {
            if (0 != start && 0 != end) {
                return BOTH_ARE_SET;
            }
            if (0 != start && 0 == end) {
                return END_NOT_SET;
            }
            if (0 == start && 0 != end) {
                return START_NOT_SET;
            }
            if (0 == start && 0 == end) {
                return BOTH_NOT_SET;
            }
        }
        return "";
    }

    private static String substringChecked(String s, int signedStart, int signedEnd, String fillString, boolean autoFill) {
        String newString;
        String resultString = "";
        if (!SubstringUtil.isNegative(signedStart) && !SubstringUtil.isNegative(signedEnd) && signedStart < signedEnd) {
            newString = s.substring(signedStart, signedEnd);
            resultString = SubstringUtil.fillString(newString, fillString, autoFill, s.length(), signedStart, s.length() - signedEnd);
        }
        if (!SubstringUtil.isNegative(signedStart) && SubstringUtil.isNegative(signedEnd) && signedStart < SubstringUtil.getIndexfromNegative(s, signedEnd)) {
            newString = s.substring(signedStart, SubstringUtil.getIndexfromNegative(s, signedEnd));
            resultString = SubstringUtil.fillString(newString, fillString, autoFill, s.length(), signedStart, Math.abs(signedEnd));
        }
        if (SubstringUtil.isNegative(signedStart) && !SubstringUtil.isNegative(signedEnd) && SubstringUtil.getIndexfromNegative(s, signedStart) > signedEnd) {
            resultString = SubstringUtil.cutBetween(s, SubstringUtil.getIndexfromNegative(s, signedStart), signedEnd, fillString, autoFill);
        }
        if (SubstringUtil.isNegative(signedStart) && SubstringUtil.isNegative(signedEnd) && SubstringUtil.getIndexfromNegative(s, signedStart) < SubstringUtil.getIndexfromNegative(s, signedEnd)) {
            newString = s.substring(SubstringUtil.getIndexfromNegative(s, signedStart), SubstringUtil.getIndexfromNegative(s, signedEnd));
            resultString = SubstringUtil.fillString(newString, fillString, autoFill, s.length(), SubstringUtil.getIndexfromNegative(s, signedStart), Math.abs(signedEnd));
        }
        return resultString;
    }

    private static String cutBetween(String s, int startIndex, int endIndex, String fillString, boolean autoFill) {
        if (autoFill) {
            return s.substring(0, endIndex) + SubstringUtil.buildFillString(s.length(), s.length() - (startIndex - endIndex), fillString) + s.substring(startIndex);
        }
        return s.substring(0, endIndex) + fillString + s.substring(startIndex);
    }

    private static boolean isNegative(int i) {
        return i < 0;
    }

    private static int getIndexfromNegative(String s, int negativeInt) {
        int resultInt = s.length() + negativeInt;
        if (SubstringUtil.isNegative(resultInt)) {
            resultInt = 0;
        }
        return resultInt;
    }

    private static String fillSuffix(String newString, String fillString, boolean autoFill, int orgLength) {
        if (autoFill) {
            return newString + SubstringUtil.buildFillString(orgLength, newString.length(), fillString);
        }
        return newString + fillString;
    }

    private static String fillPrefix(String newString, String fillString, boolean autoFill, int orgLength) {
        if (autoFill) {
            return SubstringUtil.buildFillString(orgLength, newString.length(), fillString) + newString;
        }
        return fillString + newString;
    }

    private static String fillString(String newString, String fillString, boolean autoFill, int orgLength, int frontCut, int backCut) {
        if (autoFill) {
            return SubstringUtil.buildFillString(frontCut, 0, fillString) + newString + SubstringUtil.buildFillString(backCut, 0, fillString);
        }
        return fillString + newString + fillString;
    }

    private static String buildFillString(int orgLength, int newLength, String fillString) {
        int fillLength = orgLength - newLength;
        if (fillLength < fillString.length()) {
            return fillString.substring(0, fillLength);
        }
        if (fillLength > fillString.length()) {
            StringBuilder stringBuilder = new StringBuilder(fillString);
            while (fillLength > stringBuilder.length()) {
                stringBuilder.append(fillString);
            }
            return SubstringUtil.buildFillString(orgLength, newLength, stringBuilder.toString());
        }
        return fillString;
    }
}

