/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iese.ind2uce.pep.common;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.MapFunction;
import com.jayway.jsonpath.Predicate;
import de.fraunhofer.iese.ind2uce.api.common.Ind2uceEntity;
import de.fraunhofer.iese.ind2uce.api.policy.parameter.ParameterList;
import de.fraunhofer.iese.ind2uce.pep.common.ModifierMethod;
import java.lang.reflect.Method;
import java.util.ArrayList;
import net.minidev.json.JSONArray;

public abstract class PrimitiveModifierMethod
implements ModifierMethod {
    private MapFunction mapModification;

    @Override
    public abstract Object doModification(Object var1, ParameterList var2);

    @Override
    public DocumentContext doModification(DocumentContext documentContext, String expression, ParameterList modifierMethodParameterList) {
        Gson gson = Ind2uceEntity.getGson();
        if (documentContext.read(expression, new Predicate[0]) instanceof JsonObject) {
            throw new IllegalArgumentException("While searching for JsonPrimitives, found a JsonObject!");
        }
        if (documentContext.read(expression, new Predicate[0]) instanceof JsonPrimitive) {
            JsonPrimitive expressionResult = (JsonPrimitive)documentContext.read(expression, new Predicate[0]);
            Object modObject = this.doModificationToPrimitive(expressionResult, modifierMethodParameterList);
            if ("$".equals(expression)) {
                return JsonPath.parse((String)gson.toJson(modObject), (Configuration)documentContext.configuration());
            }
            return documentContext.set(expression, modObject, new Predicate[0]);
        }
        if (documentContext.read(expression, new Predicate[0]) instanceof JsonArray || documentContext.read(expression, new Predicate[0]) instanceof JSONArray) {
            this.mapModification = (javaObject, configuration) -> {
                if (javaObject instanceof JsonObject) {
                    throw new IllegalArgumentException("While searching for JsonPrimitives, found a JsonObject!");
                }
                if (javaObject instanceof JsonArray) {
                    ArrayList<Object> modArray = new ArrayList<Object>();
                    for (Object element : (JsonArray)javaObject) {
                        modArray.add(this.mapModification.map(element, configuration));
                    }
                    return gson.fromJson(gson.toJson(modArray), JsonArray.class);
                }
                if (javaObject instanceof JsonPrimitive) {
                    return this.doModificationToPrimitive((JsonPrimitive)javaObject, modifierMethodParameterList);
                }
                return this.doModification(javaObject, modifierMethodParameterList);
            };
            return documentContext.map(expression, this.mapModification, new Predicate[0]);
        }
        return documentContext;
    }

    private Object doModificationToPrimitive(JsonPrimitive jsonPrimitive, ParameterList modifierMethodParameterList) {
        Object javaObject;
        if (jsonPrimitive.isNumber()) {
            String numberString = jsonPrimitive.toString();
            javaObject = numberString.contains(".") ? (Number)Double.parseDouble(numberString) : (Number)Long.parseLong(numberString);
        } else if (jsonPrimitive.isBoolean()) {
            javaObject = jsonPrimitive.getAsBoolean();
        } else if (jsonPrimitive.isString()) {
            javaObject = jsonPrimitive.getAsString();
        } else {
            throw new IllegalArgumentException("jsonPrimitive is none of the above. This should never happen!");
        }
        return this.doModification(javaObject, modifierMethodParameterList);
    }

    @Override
    public boolean nameIsValid() {
        Method[] methods;
        for (Method m : methods = this.getClass().getMethods()) {
            if (!m.getName().equalsIgnoreCase(this.getDisplayName())) continue;
            return true;
        }
        return false;
    }
}

