/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iese.ind2uce.pep.common;

import com.google.gson.JsonPrimitive;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonUtil {
    private static final Logger LOG = LoggerFactory.getLogger(CommonUtil.class);

    private CommonUtil() {
    }

    public static String getFromStringOrJsonPrimitive(Object input) {
        if (input instanceof String) {
            return (String)input;
        }
        if (input instanceof JsonPrimitive) {
            return ((JsonPrimitive)input).getAsString();
        }
        throw new IllegalArgumentException("Only Strings allowed");
    }

    public static Integer getIntegerFromObject(Object input) {
        if (null == input) {
            return 0;
        }
        if (input instanceof Integer) {
            return (Integer)input;
        }
        try {
            return (int)Math.round(Double.parseDouble((String)input));
        }
        catch (Exception e) {
            LOG.info("Can not be cast into double", (Throwable)e);
            return Integer.parseInt(input.toString());
        }
    }

    public static boolean getbooleanFromObject(Object o) {
        try {
            return Boolean.parseBoolean("" + o);
        }
        catch (Exception e) {
            LOG.info("Can not parse Object to boolean", (Throwable)e);
            return false;
        }
    }

    public static String fixStringObject(Object o) {
        if (null == o) {
            return "";
        }
        return o.toString();
    }
}

