/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iese.ind2uce.pep;

import de.fraunhofer.iese.ind2uce.api.component.PepComponent;
import de.fraunhofer.iese.ind2uce.api.component.description.ModifierInterfaceDescription;
import de.fraunhofer.iese.ind2uce.api.component.description.PepInterfaceDescription;
import de.fraunhofer.iese.ind2uce.api.component.identifier.ComponentId;
import de.fraunhofer.iese.ind2uce.api.component.interfaces.IPolicyManagementPoint;
import de.fraunhofer.iese.ind2uce.connectors.ConnectorFactory;
import de.fraunhofer.iese.ind2uce.connectors.OAuthCredentials;
import de.fraunhofer.iese.ind2uce.pep.DefaultPolicyEnforcementPoint;
import de.fraunhofer.iese.ind2uce.pep.common.DecisionEnforcer;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PolicyEnforcementPoint
extends DefaultPolicyEnforcementPoint {
    private static final Logger LOG = LoggerFactory.getLogger(PolicyEnforcementPoint.class);
    private static final long serialVersionUID = -3408886626406980250L;
    private final ComponentId id;
    private final List<PepInterfaceDescription> pepInterfaceDescriptions;
    private final List<ModifierInterfaceDescription> modifierInterfaceDescriptions;
    private final URI pepUrl;
    private PepComponent pepComponent;
    private IPolicyManagementPoint pmp;

    public PolicyEnforcementPoint(DecisionEnforcer decisionEnforcer, ComponentId id, URI pmpUrl, List<PepInterfaceDescription> pepInterfaceDescriptions, List<ModifierInterfaceDescription> modifierInterfaceDescriptions, URI pepUrl, boolean initialize, OAuthCredentials credentials) throws IOException {
        super(pmpUrl, decisionEnforcer, credentials);
        this.id = id;
        this.pepUrl = pepUrl;
        this.pepInterfaceDescriptions = pepInterfaceDescriptions;
        this.modifierInterfaceDescriptions = modifierInterfaceDescriptions;
        if (initialize) {
            this.initialize(new String[0]);
        }
    }

    @Override
    public ComponentId getId() throws IOException {
        return this.id;
    }

    @Override
    public boolean initialize(String ... args) throws IOException {
        super.initPpdConnection();
        this.pmp = ConnectorFactory.getPmpClient((URI)this.pmpUrl, (OAuthCredentials)this.oauthClientCredentials);
        this.pepComponent = new PepComponent(this.id);
        this.pepComponent.addUrl(this.pepUrl != null ? this.pepUrl : null);
        this.pepComponent.setInterfaceDescriptions(this.pepInterfaceDescriptions);
        this.pepComponent.setModifierDescriptionList(this.modifierInterfaceDescriptions);
        boolean registrationStatus = this.pmp.registerPEPComponent(this.pepComponent);
        if (Boolean.valueOf(registrationStatus).booleanValue()) {
            LOG.info("PEP initialization is done!");
        } else {
            LOG.warn("an error occurred while initializing PEP component");
        }
        return registrationStatus;
    }
}

