/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iese.ind2uce.json.schema;

import de.fraunhofer.iese.ind2uce.api.component.description.ClassTypeDescription;
import de.fraunhofer.iese.ind2uce.api.component.description.JsonType;
import de.fraunhofer.iese.ind2uce.api.component.description.TypeDescription;
import de.fraunhofer.iese.ind2uce.json.schema.JavaReflectionUtils;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonSchemaGenerator {
    private static final Logger LOG = LoggerFactory.getLogger(JsonSchemaGenerator.class);
    public static final String MAP_FULL_QUALIFIED_CLASSNAME = "java.util.Map";
    public static final String GENERIC_BEGIN = "<";
    public static final String GENERIC_END = ">";

    private JsonSchemaGenerator() {
    }

    private static TypeDescription addArrayType(Map<String, TypeDescription> map, Class aClass) throws ClassNotFoundException {
        TypeDescription arrayTypeDescription = new TypeDescription();
        arrayTypeDescription.setJsonType(JsonType.ARRAY);
        arrayTypeDescription.setTypeName(aClass.getComponentType().getName());
        if (!map.containsKey(aClass.getComponentType().getTypeName())) {
            JsonSchemaGenerator.createMap(map, aClass.getComponentType(), aClass.getComponentType());
        }
        return arrayTypeDescription;
    }

    private static void addComplexType(Map<String, TypeDescription> map, Type type, Class aClass) throws ClassNotFoundException {
        ClassTypeDescription classTypeDescription = new ClassTypeDescription();
        classTypeDescription.setJsonType(JsonType.OBJECT);
        classTypeDescription.setTypeName(type.getTypeName());
        map.put(type.getTypeName(), (TypeDescription)classTypeDescription);
        Field[] allComplexObjectFields = JavaReflectionUtils.getAllFields(aClass);
        JsonSchemaGenerator.addFieldDescriptionOfComplexType(map, classTypeDescription, allComplexObjectFields);
    }

    private static void addDescriptionForField(Map<String, TypeDescription> map, ClassTypeDescription classTypeDescription, Field complexObjectFields) throws ClassNotFoundException {
        Class<?> objectFieldClass = complexObjectFields.getType();
        if (JavaReflectionUtils.isIterable(objectFieldClass)) {
            ParameterizedType parameterizedType = (ParameterizedType)complexObjectFields.getGenericType();
            Type[] iterableParametrizedTypes = parameterizedType.getActualTypeArguments();
            if (iterableParametrizedTypes != null && iterableParametrizedTypes.length > 0) {
                Class<?> iterableParametrizedClass = Class.forName(iterableParametrizedTypes[0].getTypeName());
                if (!map.containsKey(iterableParametrizedTypes[0].getTypeName())) {
                    JsonSchemaGenerator.createMap(map, iterableParametrizedTypes[0], iterableParametrizedClass);
                }
                classTypeDescription.addFields(complexObjectFields.getName(), JsonSchemaGenerator.createReferenceTypeDescription(iterableParametrizedTypes[0].getTypeName(), JsonType.ARRAY));
            } else {
                TypeDescription objectTypeDescription = new TypeDescription();
                objectTypeDescription.setJsonType(JsonType.PRIMITIVE);
                objectTypeDescription.setTypeName(Object.class.getSimpleName());
                classTypeDescription.addFields(complexObjectFields.getName(), objectTypeDescription);
            }
        } else if (objectFieldClass.isArray()) {
            classTypeDescription.addFields(complexObjectFields.getName(), JsonSchemaGenerator.addArrayType(map, objectFieldClass));
        } else if (JavaReflectionUtils.isInd2ucePrimitive(objectFieldClass)) {
            classTypeDescription.addFields(complexObjectFields.getName(), JsonSchemaGenerator.addPrimitiveType(map, objectFieldClass));
        } else if (JavaReflectionUtils.isMap(objectFieldClass)) {
            if (complexObjectFields.getGenericType() instanceof ParameterizedType) {
                ClassTypeDescription mapTypeDescription = JsonSchemaGenerator.addMapType(map, complexObjectFields.getGenericType());
                classTypeDescription.addFields(complexObjectFields.getName(), (TypeDescription)mapTypeDescription);
            }
        } else {
            if (!map.containsKey(objectFieldClass.getName())) {
                JsonSchemaGenerator.createMap(map, objectFieldClass, objectFieldClass);
            }
            classTypeDescription.addFields(complexObjectFields.getName(), JsonSchemaGenerator.createReferenceTypeDescription(objectFieldClass.getName(), JsonType.OBJECT));
        }
    }

    private static void addFieldDescriptionOfComplexType(Map<String, TypeDescription> map, ClassTypeDescription classTypeDescription, Field[] allComplexObjectFields) throws ClassNotFoundException {
        for (Field complexObjectFields : allComplexObjectFields) {
            JsonSchemaGenerator.addDescriptionForField(map, classTypeDescription, complexObjectFields);
        }
    }

    private static void addIterableType(Map<String, TypeDescription> map, ParameterizedType type) {
        TypeDescription iterableTypeDescription = new TypeDescription();
        iterableTypeDescription.setJsonType(JsonType.ARRAY);
        ParameterizedType parameterizedType = type;
        Type[] iterableParametrizedTypes = parameterizedType.getActualTypeArguments();
        if (iterableParametrizedTypes != null && iterableParametrizedTypes.length > 0) {
            try {
                Class<?> iterableParametrizedClass = Class.forName(iterableParametrizedTypes[0].getTypeName());
                if (!map.containsKey(iterableParametrizedTypes[0].getTypeName())) {
                    JsonSchemaGenerator.createMap(map, iterableParametrizedTypes[0], iterableParametrizedClass);
                }
                iterableTypeDescription.setTypeName(iterableParametrizedTypes[0].getTypeName());
                map.put(iterableParametrizedTypes[0].getTypeName() + "List", iterableTypeDescription);
            }
            catch (Exception e) {
                LOG.error("Exception in JsonSchemaGenerator.addIterableType", (Throwable)e);
            }
        } else {
            iterableTypeDescription.setTypeName(Object.class.getSimpleName());
        }
    }

    private static ClassTypeDescription addMapType(Map<String, TypeDescription> map, Type type) {
        if (type instanceof ParameterizedType) {
            Type mapType = ((ParameterizedType)type).getActualTypeArguments()[1];
            try {
                return JsonSchemaGenerator.createMapTypeDescription(map, mapType);
            }
            catch (Exception e) {
                LOG.error("Exception in JsonSchemaGenerator.addMapType", (Throwable)e);
            }
        }
        return null;
    }

    private static TypeDescription addPrimitiveType(Map<String, TypeDescription> map, Class aClass) {
        TypeDescription primitiveTypeDescription = new TypeDescription();
        primitiveTypeDescription.setJsonType(JsonType.PRIMITIVE);
        primitiveTypeDescription.setTypeName(aClass.getName());
        return primitiveTypeDescription;
    }

    private static void createMap(Map<String, TypeDescription> map, Type type, Class aClass) throws ClassNotFoundException {
        if (JavaReflectionUtils.isIterable(aClass)) {
            JsonSchemaGenerator.addIterableType(map, (ParameterizedType)type);
        } else if (aClass.isArray()) {
            map.put(aClass.getComponentType().getName(), JsonSchemaGenerator.addArrayType(map, aClass));
        } else if (JavaReflectionUtils.isMap(aClass)) {
            JsonSchemaGenerator.addMapType(map, type);
        } else if (JavaReflectionUtils.isInd2ucePrimitive(aClass)) {
            map.put(aClass.getName(), JsonSchemaGenerator.addPrimitiveType(map, aClass));
        } else {
            JsonSchemaGenerator.addComplexType(map, type, aClass);
        }
    }

    private static ClassTypeDescription createMapTypeDescription(Map<String, TypeDescription> map, Type mapType) throws ClassNotFoundException {
        Class<?> mapTypeClass = Class.forName(mapType.getTypeName());
        if (!map.containsKey("java.util.Map<" + mapType.getTypeName() + GENERIC_END)) {
            JsonSchemaGenerator.createMap(map, mapType, mapTypeClass);
        }
        ClassTypeDescription mapClassTypeDescription = new ClassTypeDescription();
        mapClassTypeDescription.setJsonType(JsonType.OBJECT);
        mapClassTypeDescription.setTypeName("java.util.Map<" + mapType.getTypeName() + GENERIC_END);
        if (JavaReflectionUtils.isInd2ucePrimitive(mapTypeClass)) {
            mapClassTypeDescription.addFields("*", JsonSchemaGenerator.createReferenceTypeDescription(mapType.getTypeName(), JsonType.PRIMITIVE));
        } else {
            mapClassTypeDescription.addFields("*", JsonSchemaGenerator.createReferenceTypeDescription(mapType.getTypeName(), JsonType.OBJECT));
        }
        map.put("java.util.Map<" + mapType.getTypeName() + GENERIC_END, (TypeDescription)mapClassTypeDescription);
        return mapClassTypeDescription;
    }

    private static TypeDescription createReferenceTypeDescription(String typeName, JsonType jsonType) {
        TypeDescription typeDescription = new TypeDescription();
        typeDescription.setTypeName(typeName);
        typeDescription.setJsonType(jsonType);
        return typeDescription;
    }

    public static List<TypeDescription> createTypeDescription(Type type, Class typeClass) throws ClassNotFoundException {
        HashMap<String, TypeDescription> typeNameAndTypeDescriptionMap = new HashMap<String, TypeDescription>();
        JsonSchemaGenerator.createMap(typeNameAndTypeDescriptionMap, type, typeClass);
        return new LinkedList<TypeDescription>(typeNameAndTypeDescriptionMap.values());
    }

    public static JsonType getJsonType(Class type) {
        if (JavaReflectionUtils.isInd2ucePrimitive(type)) {
            return JsonType.PRIMITIVE;
        }
        if (JavaReflectionUtils.isIterable(type) || type.isArray()) {
            return JsonType.ARRAY;
        }
        return JsonType.OBJECT;
    }
}

