/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iese.ind2uce.registry;

import de.fraunhofer.iese.ind2uce.api.component.Component;
import de.fraunhofer.iese.ind2uce.api.component.description.MethodInterfaceDescription;
import de.fraunhofer.iese.ind2uce.api.component.identifier.ComponentId;
import de.fraunhofer.iese.ind2uce.api.component.identifier.EnforcementScopeId;
import de.fraunhofer.iese.ind2uce.registry.ComponentType;
import de.fraunhofer.iese.ind2uce.registry.InterfaceDescriptionDiscovery;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;

public class ComponentFactory {
    private final InterfaceDescriptionDiscovery discovery = new InterfaceDescriptionDiscovery();

    public Component create(Class serviceClass, Class<? extends Annotation> annotationClassOfBean, ComponentType componentType, EnforcementScopeId scope, String prefix) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Annotation a = serviceClass.getAnnotation(annotationClassOfBean);
        ComponentId componentId = new ComponentId((String)a.getClass().getMethod("componentId", new Class[0]).invoke((Object)a, new Object[0]));
        Component toReturn = new Component(componentId);
        String path = (String)a.getClass().getMethod("path", new Class[0]).invoke((Object)a, new Object[0]);
        toReturn.setUrls(Arrays.asList(this.createFullUrl(prefix, path)));
        Map<MethodInterfaceDescription, Method> discover = this.discovery.discover(serviceClass, componentType, scope);
        toReturn.setComponentInterfaces(new ArrayList<MethodInterfaceDescription>(discover.keySet()));
        return toReturn;
    }

    private URI createFullUrl(String prefix, String path) {
        StringBuilder fullPath = new StringBuilder(prefix);
        this.addServicePath(fullPath, path);
        return URI.create(fullPath.toString());
    }

    private void addServicePath(StringBuilder toReturn, String path) {
        if (!(toReturn.toString().endsWith("/") || path != null && path.startsWith("/"))) {
            toReturn.append("/");
        }
        if (path != null) {
            toReturn.append(path);
        }
    }
}

