/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iese.ind2uce.pep.modifiermethods;

import de.fraunhofer.iese.ind2uce.api.policy.parameter.ParameterList;
import de.fraunhofer.iese.ind2uce.pep.common.PrimitiveModifierMethod;
import de.fraunhofer.iese.ind2uce.registry.ActionDescription;
import de.fraunhofer.iese.ind2uce.registry.ActionParameterDescription;

public class SignModifierMethod
extends PrimitiveModifierMethod {
    @Override
    public String getDisplayName() {
        return "sign";
    }

    @Override
    public Object doModification(Object currentObject, ParameterList modifierMethodParameterList) {
        Object modeObj = modifierMethodParameterList.getParameterValueForName("mode");
        String mode = modeObj == null ? "none" : (String)modeObj;
        Number result = null;
        if (currentObject instanceof Integer) {
            result = this.sign((Integer)currentObject, mode).intValue();
        }
        if (currentObject instanceof Long) {
            result = this.sign((Long)currentObject, mode).longValue();
        }
        if (currentObject instanceof Float) {
            result = Float.valueOf(this.sign((Float)currentObject, mode).floatValue());
        }
        if (currentObject instanceof Double) {
            result = this.sign((Double)currentObject, mode).doubleValue();
        }
        return result;
    }

    @ActionDescription(description="Takes the absolute value, negative value or toggles the current sign of the target", pepSupportedType=Number.class)
    public Number sign(Number currentNumber, @ActionParameterDescription(name="mode", description="operation mode: 'absolute', 'negative' or 'toggle'; 'none' is the default", mandatory=true) String mode) {
        if ("absolute".equals(mode)) {
            return Math.abs(currentNumber.doubleValue());
        }
        if ("negative".equals(mode)) {
            return -Math.abs(currentNumber.doubleValue());
        }
        if ("toggle".equals(mode)) {
            return -currentNumber.doubleValue();
        }
        return currentNumber;
    }
}

