/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iese.ind2uce.pep.modifiermethods;

import de.fraunhofer.iese.ind2uce.api.policy.parameter.ParameterList;
import de.fraunhofer.iese.ind2uce.pep.common.PrimitiveModifierMethod;
import de.fraunhofer.iese.ind2uce.registry.ActionDescription;
import de.fraunhofer.iese.ind2uce.registry.ActionParameterDescription;

public class RoundModifierMethod
extends PrimitiveModifierMethod {
    @Override
    public String getDisplayName() {
        return "round";
    }

    @Override
    public Object doModification(Object currentObject, ParameterList modifierMethodParameterList) {
        Object modeObj = modifierMethodParameterList.getParameterValueForName("mode");
        Object intervalObj = modifierMethodParameterList.getParameterValueForName("interval");
        Object offsetObj = modifierMethodParameterList.getParameterValueForName("offset");
        String mode = modeObj == null ? "round" : (String)modeObj;
        Double interval = intervalObj == null ? 1.0 : (Double)intervalObj;
        Double offset = offsetObj == null ? 0.0 : (Double)offsetObj;
        Number result = null;
        if (currentObject instanceof Integer) {
            result = this.round((Integer)currentObject, mode, interval, offset).intValue();
        }
        if (currentObject instanceof Long) {
            result = this.round((Long)currentObject, mode, interval, offset).longValue();
        }
        if (currentObject instanceof Float) {
            result = Float.valueOf(this.round((Float)currentObject, mode, interval, offset).floatValue());
        }
        if (currentObject instanceof Double) {
            result = this.round((Double)currentObject, mode, interval, offset).doubleValue();
        }
        return result;
    }

    @ActionDescription(description="Rounds, ceils or floors the target number to the closest point defined by interval and offset", pepSupportedType=Number.class)
    public Number round(Number currentNumber, @ActionParameterDescription(name="mode", description="Operation mode: 'round', 'ceil' or 'floor'; default is 'round'", mandatory=false) String mode, @ActionParameterDescription(name="interval", description="Interval of rounding; default is 1", mandatory=false) Double interval, @ActionParameterDescription(name="offset", description="Offset of rounding; default is 0", mandatory=false) Double offset) {
        if ("round".equals(mode)) {
            return (double)Math.round((currentNumber.doubleValue() - offset) / interval) * interval + offset;
        }
        if ("ceil".equals(mode)) {
            return Math.ceil((currentNumber.doubleValue() - offset) / interval) * interval + offset;
        }
        if ("floor".equals(mode)) {
            return Math.floor((currentNumber.doubleValue() - offset) / interval) * interval + offset;
        }
        throw new IllegalArgumentException("Mode must be 'round', 'ceil' or 'floor'");
    }
}

