/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iese.ind2uce.pep.modifiermethods;

import de.fraunhofer.iese.ind2uce.api.policy.parameter.ParameterList;
import de.fraunhofer.iese.ind2uce.pep.common.PrimitiveModifierMethod;
import de.fraunhofer.iese.ind2uce.registry.ActionDescription;
import de.fraunhofer.iese.ind2uce.registry.ActionParameterDescription;

public class ReplaceSubStringModifierMethod
extends PrimitiveModifierMethod {
    @Override
    public String getDisplayName() {
        return "replaceSubstring";
    }

    @Override
    public Object doModification(Object currentObject, ParameterList modifierMethodParameterList) {
        Object substringObj = modifierMethodParameterList.getParameterValueForName("substring");
        Object replacementObj = modifierMethodParameterList.getParameterValueForName("replacement");
        Object modeObj = modifierMethodParameterList.getParameterValueForName("mode");
        String mode = modeObj == null ? "literal" : modeObj.toString();
        return this.replaceSubstring(currentObject.toString(), substringObj.toString(), replacementObj.toString(), mode);
    }

    @ActionDescription(description="Replaces all matches of the substring with the replacement", pepSupportedType=String.class)
    public String replaceSubstring(String currentString, @ActionParameterDescription(name="substring", description="Literal substring or regex to search for", mandatory=true) String substring, @ActionParameterDescription(name="replacement", description="Replacement for the search matches", mandatory=true) String replacement, @ActionParameterDescription(name="mode", description="Defines what the substring is: 'literal' or 'regex'. Defaults to literal", mandatory=false) String mode) {
        if ("literal".equals(mode)) {
            return currentString.replace(substring, replacement);
        }
        if ("regex".equals(mode)) {
            return currentString.replaceAll(substring, replacement);
        }
        throw new IllegalArgumentException("Mode must be 'literal' or 'regex'");
    }
}

