/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iese.ind2uce.pep.modifiermethods;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import com.jayway.jsonpath.Criteria;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.Filter;
import com.jayway.jsonpath.MapFunction;
import com.jayway.jsonpath.Predicate;
import de.fraunhofer.iese.ind2uce.api.policy.parameter.ParameterList;
import de.fraunhofer.iese.ind2uce.pep.common.CommonUtil;
import de.fraunhofer.iese.ind2uce.pep.common.ModifierMethod;
import de.fraunhofer.iese.ind2uce.registry.ActionDescription;
import de.fraunhofer.iese.ind2uce.registry.ActionParameterDescription;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PatternMatcherModifierMethod
implements ModifierMethod {
    private static final Logger LOG = LoggerFactory.getLogger(PatternMatcherModifierMethod.class);
    private static final String DEBTOR = "debtor";
    private static final String CREDITOR = "creditor";
    String name = "patternMatcher";
    private String parameterName;
    private final Set<String> idsToModify = new HashSet<String>();
    private final Gson gson = new GsonBuilder().setPrettyPrinting().create();

    @Override
    public DocumentContext doModification(DocumentContext documentContext, String expression, ParameterList modifierMethodParameterList) {
        boolean resetList = (Boolean)modifierMethodParameterList.getParameterValueForName("resetList");
        if (resetList) {
            this.idsToModify.clear();
        }
        this.parameterName = (String)modifierMethodParameterList.getParameterValueForName("parameterName");
        Map tuples = (Map)modifierMethodParameterList.getParameterValueForName("tuples");
        String method = (String)modifierMethodParameterList.getParameterValueForName("method");
        String amountExpression = modifierMethodParameterList.getParameterValueForName("amountExpression").toString();
        int percentage = (int)Math.round((Double)modifierMethodParameterList.getParameterValueForName("percentage"));
        return this.patternMatcher(tuples, amountExpression, percentage, documentContext, expression, method, resetList);
    }

    @Override
    public Object doModification(Object currentObject, ParameterList modifierMethodParameterList) {
        return null;
    }

    @ActionDescription(description="Appends a prefix and/or suffix to an event parameter value", pepSupportedType=String.class)
    public DocumentContext patternMatcher(@ActionParameterDescription(name="tuples", description="tuples", mandatory=false) Object tuples, @ActionParameterDescription(name="amountExpression", description="amountExpression", mandatory=false) String amountExpression, @ActionParameterDescription(name="percentage", description="percentage", mandatory=false) Number percentage, DocumentContext documentContext, String expression, @ActionParameterDescription(name="method", description="method", mandatory=false) String method, @ActionParameterDescription(name="resetList", description="resetList", mandatory=false) Boolean resetList) {
        String pathReader;
        String pathFilter;
        LOG.info("doModify PatternMatcherr with expression {} ", (Object)expression);
        if (resetList.booleanValue()) {
            this.idsToModify.clear();
        }
        try {
            documentContext.read("$['" + this.parameterName + "'][*]", new Predicate[0]);
            pathFilter = "$['" + this.parameterName + "'][?]";
            pathReader = "$['" + this.parameterName + "'][*]";
        }
        catch (Exception e) {
            LOG.info("Problem trying to read parameterName, try with *", (Throwable)e);
            documentContext.read("$[*]", new Predicate[0]);
            pathFilter = "$[?]";
            pathReader = "$[*]";
        }
        ArrayList<MapFunction> blurMethods = new ArrayList<MapFunction>();
        String methodName = method.toString().split("-")[0];
        String caracter = null;
        try {
            caracter = method.toString().split("-")[1];
        }
        catch (Exception e) {
            LOG.debug("Problem trying to get 2nd element, try with DEFAULT", (Throwable)e);
            caracter = "DEFAULT";
        }
        if ((Integer)percentage > 0) {
            caracter = caracter + percentage + "%";
        }
        String carac = caracter;
        if ((Integer)percentage > 0) {
            blurMethods.add((o, configuration) -> this.anagram(o, (Integer)percentage).getAsString());
        } else if (methodName.equalsIgnoreCase("replace") && caracter != null) {
            blurMethods.add((o, configuration) -> this.replace(carac).getAsString());
        }
        if (methodName.equalsIgnoreCase("suffix") && caracter != null) {
            blurMethods.add((o, configuration) -> this.append(o, carac).getAsString());
        }
        Map tuplesMap = (Map)tuples;
        for (Map.Entry mapEntry : tuplesMap.entrySet()) {
            JsonArray document;
            Filter expensiveFilter;
            String mapKey = (String)mapEntry.getKey();
            if ((Double)mapEntry.getValue() != -1.0) {
                Double maxAmount = Math.abs((Double)mapEntry.getValue());
                expensiveFilter = Filter.filter((Predicate)Criteria.where((String)amountExpression).gt((Object)0).and(amountExpression).gt((Object)maxAmount).and(DEBTOR).contains((Object)mapKey)).or((Predicate)Criteria.where((String)amountExpression).gt((Object)0).and(amountExpression).gt((Object)maxAmount).and(CREDITOR).contains((Object)mapKey)).or((Predicate)Criteria.where((String)amountExpression).lt((Object)0).and(amountExpression).lt((Object)(maxAmount * -1.0)).and(DEBTOR).contains((Object)mapKey)).or((Predicate)Criteria.where((String)amountExpression).lt((Object)0).and(amountExpression).lt((Object)(maxAmount * -1.0)).and(CREDITOR).contains((Object)mapKey)).or((Predicate)Criteria.where((String)"id").in(this.idsToModify));
            } else {
                expensiveFilter = Filter.filter((Predicate)Criteria.where((String)amountExpression).gt((Object)0).and(DEBTOR).contains((Object)mapKey)).or((Predicate)Criteria.where((String)amountExpression).gt((Object)0).and(CREDITOR).contains((Object)mapKey)).or((Predicate)Criteria.where((String)amountExpression).lt((Object)0).and(DEBTOR).contains((Object)mapKey)).or((Predicate)Criteria.where((String)amountExpression).lt((Object)0).and(CREDITOR).contains((Object)mapKey)).or((Predicate)Criteria.where((String)"id").in(this.idsToModify));
            }
            Object filtred = documentContext.read(pathFilter, new Predicate[]{expensiveFilter});
            JsonArray filteredArray = (JsonArray)filtred;
            ArrayList<String> ids = new ArrayList<String>();
            for (JsonElement jsonElement : filteredArray) {
                ids.add(jsonElement.getAsJsonObject().get("id").getAsString());
            }
            this.idsToModify.addAll(ids);
            Filter excludeFilter = Filter.filter((Predicate)Criteria.where((String)"id").nin(ids));
            JsonArray copy = (JsonArray)documentContext.read(pathFilter, new Predicate[]{excludeFilter});
            documentContext.delete(pathReader, new Predicate[0]);
            try {
                documentContext.put("$", this.parameterName, (Object)filteredArray, new Predicate[0]);
            }
            catch (Exception e) {
                LOG.info("Problem putting parameterName and filteredArray to documentContext, retry without parameterName", (Throwable)e);
                documentContext.add("$", (Object)filteredArray, new Predicate[0]);
            }
            if (methodName.equalsIgnoreCase("delete") && caracter != null) {
                document = copy;
                documentContext.delete(pathReader, new Predicate[0]);
            } else {
                for (MapFunction blur : blurMethods) {
                    documentContext = documentContext.map(expression, blur, new Predicate[]{expensiveFilter});
                }
                document = (JsonArray)documentContext.read(pathReader, new Predicate[0]);
                document.addAll(copy);
                documentContext.delete(pathReader, new Predicate[0]);
            }
            try {
                documentContext.put("$", this.parameterName, (Object)document, new Predicate[0]);
            }
            catch (Exception e) {
                LOG.info("Problem putting parameterName and document to documentContext, retry without parameterName", (Throwable)e);
                documentContext.add("$", (Object)document, new Predicate[0]);
            }
        }
        return documentContext;
    }

    private JsonElement append(Object input, Object suffix) {
        String sInput = CommonUtil.getFromStringOrJsonPrimitive(input);
        StringBuilder builder = new StringBuilder();
        builder.append(sInput);
        if (suffix != null && sInput.indexOf(suffix.toString()) < 0) {
            builder.append(suffix);
        }
        return (JsonElement)this.gson.fromJson(this.gson.toJson((Object)builder.toString()), JsonPrimitive.class);
    }

    private JsonElement replace(String caracter) {
        String json;
        block3: {
            json = caracter;
            try {
                if (!(json.startsWith("{") || json.startsWith("[") || json.startsWith("\""))) {
                    json = "" + json + "";
                }
            }
            catch (NumberFormatException e) {
                if (json.startsWith("{") || json.startsWith("[") || json.startsWith("\"")) break block3;
                json = "'" + json + "'";
            }
        }
        return (JsonElement)this.gson.fromJson(this.gson.toJson((Object)json), JsonPrimitive.class);
    }

    private JsonElement anagram(Object input, int percentage) {
        String sInput = CommonUtil.getFromStringOrJsonPrimitive(input);
        String resultString = this.scramble(sInput, percentage);
        return (JsonElement)this.gson.fromJson(this.gson.toJson((Object)resultString), JsonPrimitive.class);
    }

    protected String scramble(String inputString, int count) {
        if (inputString == null || inputString.length() <= 2) {
            return inputString;
        }
        boolean canBeScrambled = false;
        for (int i = 1; i < inputString.length(); ++i) {
            char c = inputString.charAt(i);
            if (c == inputString.charAt(0)) continue;
            canBeScrambled = true;
            break;
        }
        if (!canBeScrambled) {
            return inputString;
        }
        Random random = new Random();
        char[] a = inputString.toCharArray();
        int limit = Math.round((float)a.length * ((float)Math.min(count, 100) / 100.0f));
        for (int i = 0; i < Math.min(a.length - 1, limit); ++i) {
            int j = random.nextInt(Math.min(a.length - 1, limit));
            char temp = a[i];
            a[i] = a[j];
            a[j] = temp;
        }
        String result = new String(a);
        if (result.equals(inputString)) {
            result = this.scramble(inputString, count);
        }
        LOG.trace("Built anagram {}% of {} --> {}", new Object[]{count, inputString, result});
        return result;
    }

    @Override
    public String getDisplayName() {
        return this.name;
    }

    @Override
    public boolean nameIsValid() {
        Method[] methods;
        for (Method m : methods = this.getClass().getMethods()) {
            if (!m.getName().equalsIgnoreCase(this.getDisplayName())) continue;
            return true;
        }
        return false;
    }
}

