/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iese.ind2uce.pep.modifiermethods;

import de.fraunhofer.iese.ind2uce.api.policy.parameter.ParameterList;
import de.fraunhofer.iese.ind2uce.pep.common.PrimitiveModifierMethod;
import de.fraunhofer.iese.ind2uce.registry.ActionDescription;
import de.fraunhofer.iese.ind2uce.registry.ActionParameterDescription;
import java.io.IOException;
import java.util.Map;
import javax.money.Monetary;
import javax.money.UnknownCurrencyException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import retrofit2.Call;
import retrofit2.Converter;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;
import retrofit2.http.GET;
import retrofit2.http.Query;

public class CurrencyModifierMethod
extends PrimitiveModifierMethod {
    private static final Logger LOG = LoggerFactory.getLogger(CurrencyModifierMethod.class);
    private static final String CHANGE_CURRENCY = "changeCurrency";
    private static final String BASE_URL = "https://free.currencyconverterapi.com/";
    private static final String IOEXCEPTION_IN = "Exception in ";

    @Bean
    public ExchangeService exchangeService() {
        return (ExchangeService)new Retrofit.Builder().baseUrl(BASE_URL).addConverterFactory((Converter.Factory)GsonConverterFactory.create()).build().create(ExchangeService.class);
    }

    @Override
    public Object doModification(Object currentObject, ParameterList modifierMethodParameterList) {
        Object fromCurrency = modifierMethodParameterList.getParameterValueForName("fromCurrency");
        String startParam = fromCurrency != null ? fromCurrency.toString().toUpperCase() : null;
        Object toCurrency = modifierMethodParameterList.getParameterValueForName("toCurrency");
        String endParam = toCurrency != null ? toCurrency.toString().toUpperCase() : null;
        return this.changeCurrency(currentObject, startParam, endParam);
    }

    private void currencyValid(String currency) {
        Monetary.getCurrency((String)currency, (String[])new String[0]);
    }

    @ActionDescription(description="Convert the currency of an event parameter value", pepSupportedType=Number.class)
    public Number changeCurrency(Object input, @ActionParameterDescription(name="fromCurrency", description="string to define the original currency parameter", mandatory=true, type=String.class) String fromCurrency, @ActionParameterDescription(name="toCurrency", description="string to define the aimed currency parameter", mandatory=true, type=String.class) String toCurrency) {
        try {
            this.currencyValid(fromCurrency);
        }
        catch (UnknownCurrencyException e) {
            LOG.error("Unknown currency: " + fromCurrency, (Throwable)e);
            throw new IllegalArgumentException("From currency not recognized");
        }
        try {
            this.currencyValid(toCurrency);
        }
        catch (UnknownCurrencyException e) {
            LOG.error("Unknown currency: " + toCurrency, (Throwable)e);
            throw new IllegalArgumentException("To currency not recognized");
        }
        return this.convert(input, fromCurrency, toCurrency);
    }

    private double convert(Object input, String fromCurrency, String toCurrency) {
        Double amount;
        Double convertedAmount = amount = Double.valueOf(String.valueOf(input));
        try {
            String money = !"EUR".equalsIgnoreCase(fromCurrency) ? fromCurrency + "_" + toCurrency : "EUR_" + toCurrency;
            Response conversion = this.exchangeService().getExchangeRate(money, "ultra").execute();
            if (conversion != null && conversion.isSuccessful()) {
                Double rate = Double.parseDouble((String)((Map)conversion.body()).get(money));
                convertedAmount = amount * rate;
            }
        }
        catch (IOException e) {
            LOG.error(IOEXCEPTION_IN + this.getClass().getName() + ".covert()", (Throwable)e);
        }
        return convertedAmount;
    }

    public boolean convertSuccess(String fromCurrency, String toCurrency) {
        try {
            String money = !"EUR".equalsIgnoreCase(fromCurrency) ? fromCurrency + "_" + toCurrency : "EUR_" + toCurrency;
            Response conversion = this.exchangeService().getExchangeRate(money, "ultra").execute();
            return conversion.isSuccessful();
        }
        catch (IOException e) {
            LOG.error(IOEXCEPTION_IN + this.getClass().getName() + ".convertSuccess()", (Throwable)e);
            return false;
        }
    }

    @Override
    public String getDisplayName() {
        return CHANGE_CURRENCY;
    }

    public static interface ExchangeService {
        @GET(value="/api/v5/convert?")
        public Call<Map<String, String>> getExchangeRate(@Query(value="q") String var1, @Query(value="compact") String var2);
    }
}

