/*-
 * =================================LICENSE_START=================================
 * IND2UCE
 * %%
 * Copyright (C) 2016 Fraunhofer IESE (www.iese.fraunhofer.de)
 * %%
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * =================================LICENSE_END=================================
 */

package de.fraunhofer.iese.ind2uce.registry;

/**
 * All supported types of a component that should be registered.
 */
public enum ComponentType {

  /**
   * The pip.
   */
  PIP("urn:pip", "urn:info:"),

  /**
   * The pxp.
   */
  PXP("urn:pxp", "urn:action:");

  /**
   * The component id prefix.
   */
  private final String componentIdPrefix;

  /**
   * The prefix for interface description.
   */
  private final String prefixForInterfaceDescription;

  /**
   * Instantiates a new component type.
   *
   * @param componentIdPrefix the component id prefix
   * @param prefixForInterfaceDescription the prefix for interface description
   */
  ComponentType(String componentIdPrefix, String prefixForInterfaceDescription) {

    this.componentIdPrefix = componentIdPrefix;
    this.prefixForInterfaceDescription = prefixForInterfaceDescription;
  }

  /**
   * Gets the component id prefix.
   *
   * @return the component id prefix
   */
  public String getComponentIdPrefix() {
    return this.componentIdPrefix;
  }

  /**
   * Gets the prefix for interface description.
   *
   * @return the prefix for interface description
   */
  public String getPrefixForInterfaceDescription() {
    return this.prefixForInterfaceDescription;
  }

}
