/*-
 * =================================LICENSE_START=================================
 * IND2UCE
 * %%
 * Copyright (C) 2017 Fraunhofer IESE (www.iese.fraunhofer.de)
 * %%
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * =================================LICENSE_END=================================
 */
package de.fraunhofer.iese.ind2uce.registry;

import de.fraunhofer.iese.ind2uce.api.component.Component;
import de.fraunhofer.iese.ind2uce.api.component.description.MethodInterfaceDescription;
import de.fraunhofer.iese.ind2uce.api.component.identifier.ComponentId;
import de.fraunhofer.iese.ind2uce.api.component.identifier.EnforcementScopeId;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;

/**
 *
 */
public class ComponentFactory {

    private final InterfaceDescriptionDiscovery discovery = new InterfaceDescriptionDiscovery();

    public Component create(final Class serviceClass, final Class<? extends Annotation> annotationClassOfBean, ComponentType componentType, EnforcementScopeId scope, String prefix) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        final Annotation a = serviceClass.getAnnotation(annotationClassOfBean);
        ComponentId componentId = new ComponentId((String) a.getClass().getMethod("componentId").invoke(a));
        Component toReturn = new Component(componentId);
        String path = (String) a.getClass().getMethod("path").invoke(a);
        toReturn.setUrls(Arrays.asList(this.createFullUrl(prefix, path)));
        Map<MethodInterfaceDescription, Method> discover = discovery.discover(serviceClass, componentType, scope);
        toReturn.setComponentInterfaces(new ArrayList<>(discover.keySet()));
        return toReturn;
    }

    private URI createFullUrl(String prefix, String path) {

        StringBuilder fullPath = new StringBuilder(prefix);

        this.addServicePath(fullPath, path);

        return URI.create(fullPath.toString());
    }


    private void addServicePath(StringBuilder toReturn, String path) {
        if (!(toReturn.toString().endsWith("/") || path != null && path.startsWith("/"))) {
            toReturn.append("/");
        }
        if (path != null) {
            toReturn.append(path);
        }
    }

}
