/*-
 * =================================LICENSE_START=================================
 * IND2UCE
 * %%
 * Copyright (C) 2016 Fraunhofer IESE (www.iese.fraunhofer.de)
 * %%
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * =================================LICENSE_END=================================
 */

package de.fraunhofer.iese.ind2uce.reactive.common;

/**
 * Current reactive PEP state Created by chattapa on 10/23/16.
 */
public enum RxPEPState {

  /***
   * PEP is already registered at PMP.
   */
  REGISTRATION_DONE_SUCCESSFULLY,

  /***
   * PEP failed to register at PMP.
   */
  REGISTRATION_FAILED,

  /***
   * Registration to PMP has not been started yet.
   */
  REGISTRATION_NOT_STARTED,

  /***
   * Registration to PMP is being processed.
   */
  REGISTRATION_UNDER_PROCESS;

}
