/*-
 * =================================LICENSE_START=================================
 * IND2UCE
 * %%
 * Copyright (C) 2016 Fraunhofer IESE (www.iese.fraunhofer.de)
 * %%
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * =================================LICENSE_END=================================
 */

package de.fraunhofer.iese.ind2uce.reactive.common;

import de.fraunhofer.iese.ind2uce.api.component.interfaces.IPolicyEnforcementPoint;

import rx.Observable;

/**
 * Reactive PEP interface Created by chattapa on 10/23/16.
 *
 * @param <T> the generic type
 */

public interface RxPEP<T> {

  /***
   * @return the generic type
   */
  T createInstanceAPI();

  /***
   * Registers the PEP at PMP.
   *
   * @return true if PEP is registered at PMP and returns false if PEP had been
   *         registered before or registration is failed.
   */
  Observable<Boolean> doRegisterAtPMP();

  /***
   * It returns a valid instance of {@link IPolicyEnforcementPoint}
   *
   * @return {@link IPolicyEnforcementPoint}
   */
  IPolicyEnforcementPoint getPolicyEnforcementPoint();

  /**
   * Returns one of the following RxPEP states:
   * <ul>
   * <li>REGISTRATION_DONE_SUCCESSFULLY: PEP is already registered at PMP.</li>
   * <li>REGISTRATION_FAILED: PEP failed to register at PMP.</li>
   * <li>REGISTRATION_NOT_STARTED: Registration has not been started yet and PEP
   * needs to be initialized for the registration to be started.</li>
   * <li>REGISTRATION_UNDER_PROCESS: Registration is being processed.</li>
   * </ul>
   *
   * @return the current RxPEP state
   */
  RxPEPState isReady();
}
