/*-
 * =================================LICENSE_START=================================
 * IND2UCE
 * %%
 * Copyright (C) 2016 Fraunhofer IESE (www.iese.fraunhofer.de)
 * %%
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * =================================LICENSE_END=================================
 */

package de.fraunhofer.iese.ind2uce.reactive.common;

/***
 *
 */
public class PEPEventProcessingException extends Throwable {

  /***
   *
   */
  private final Object eventTag;

  private final int errorCode;

  /***
   * Create exception while error at PEP or PDP side.
   *
   * @param eventTag  eventTag
   * @param e exception
   * @param httpErrorCode error code
   */
  public PEPEventProcessingException(final Object eventTag, final Throwable e, final int httpErrorCode) {
    super(e);
    this.eventTag = eventTag;
    this.errorCode = httpErrorCode;
  }

  /**
   * Get back the HTTP error code of the exception.
   *
   * @return the HTTP error code or -1 if not applicable.
   */
  public int getErrorCode() {
    return this.errorCode;
  }

  /***
   * Get the associated event id when error occurs in PEP processing or at PDP
   * side.
   *
   * @return eventTag
   */
  public Object getEventTag() {
    return this.eventTag;
  }
}
