/*-
 * =================================LICENSE_START=================================
 * IND2UCE
 * %%
 * Copyright (C) 2016 Fraunhofer IESE (www.iese.fraunhofer.de)
 * %%
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * =================================LICENSE_END=================================
 */

package de.fraunhofer.iese.ind2uce.pep.modifiermethods;

import de.fraunhofer.iese.ind2uce.api.policy.parameter.ParameterList;
import de.fraunhofer.iese.ind2uce.pep.common.CommonUtil;
import de.fraunhofer.iese.ind2uce.pep.common.PrimitiveModifierMethod;
import de.fraunhofer.iese.ind2uce.pep.common.SubstringUtil;
import de.fraunhofer.iese.ind2uce.registry.ActionDescription;
import de.fraunhofer.iese.ind2uce.registry.ActionParameterDescription;

/****
 * This a default Modifier method with PEP sdk which appends the prefix and
 * suffix to string where event parameter is either a Json Object or string
 * (primitive type)
 */
public class SubStringModifierMethod extends PrimitiveModifierMethod {
  private static final String name = "substring";

  @Override
  public Object doModification(Object currentObject, ParameterList modifierMethodParameterList) {
    final Object start = modifierMethodParameterList.getParameterValueForName("startIndex");
    final String startParam = start != null ? start.toString() : null;
    final Object end = modifierMethodParameterList.getParameterValueForName("endIndex");
    final String endParam = end != null ? end.toString() : null;
    final Object fillString = modifierMethodParameterList.getParameterValueForName("fillString");
    final String fillStringParam = fillString != null ? fillString.toString() : "";
    final Object autoFill = modifierMethodParameterList.getParameterValueForName("autoFill");
    final String autoFillParam = autoFill != null ? autoFill.toString() : "";
    return this.substring(currentObject, startParam, endParam, fillStringParam, autoFillParam);

  }

  @ActionDescription(description = "Appends a prefix and/or suffix to an event parameter value", pepSupportedType = String.class)
  public String substring(Object input, @ActionParameterDescription(name = "startIndex", description = "int to define the start parameter", mandatory = false, type = Integer.class) Object start,
      @ActionParameterDescription(name = "endIndex", description = "int to define the end parameter", mandatory = false, type = Integer.class) Object end,
      @ActionParameterDescription(name = "fillString", description = "String to fill cuted characters", mandatory = false, type = String.class) Object fillString,
      @ActionParameterDescription(name = "autoFill", description = "auto fit length of fillString", mandatory = false, type = Boolean.class) Object autoFill) {

    final String sInput = CommonUtil.getFromStringOrJsonPrimitive(input);

    return SubstringUtil.substring(sInput, CommonUtil.getIntegerFromObject(start), CommonUtil.getIntegerFromObject(end), new StringBuilder().append(fillString).toString(),
        CommonUtil.getbooleanFromObject(autoFill));
  }

  @Override
  public String getDisplayName() {
    return name;
  }

}
