/*-
 * =================================LICENSE_START=================================
 * IND2UCE
 * %%
 * Copyright (C) 2016 Fraunhofer IESE (www.iese.fraunhofer.de)
 * %%
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * =================================LICENSE_END=================================
 */

package de.fraunhofer.iese.ind2uce.pep.modifiermethods;

import de.fraunhofer.iese.ind2uce.api.policy.parameter.ParameterList;
import de.fraunhofer.iese.ind2uce.pep.common.PrimitiveModifierMethod;
import de.fraunhofer.iese.ind2uce.registry.ActionDescription;

import org.apache.commons.lang3.StringUtils;

import java.util.Locale;

/****
 * This a default Modifier method with PEP sdk which shortens the string to it
 * first letter, set it to upper of lower case (default: upper) and append a
 * character (default: point) where event parameter is either a Json Object or
 * string (primitive type)
 */
public class ShortenInitialModifierMethod extends PrimitiveModifierMethod {

  @Override
  public String getDisplayName() {
    return "shorten";
  }

  @Override
  public Object doModification(Object currentObject, ParameterList modifierMethodParameterList) {
    final Object suffix = modifierMethodParameterList.getParameterValueForName("suffix");
    final String suffixParam = suffix != null ? suffix.toString() : ".";
    final Object caseTo = modifierMethodParameterList.getParameterValueForName("case");
    final String caseToParam = caseTo != null ? caseTo.toString() : "upper";
    return this.shorten(currentObject.toString(), suffixParam, caseToParam);
  }

  @ActionDescription(description = "Shorten a string to the first letter, change the case (per default to uppercase) and append a character (per default a point)", pepSupportedType = String.class)
  public String shorten(String name, String suffixParam, String caseToParam) {

    if (name == null) {
      return null;
    }
    final String trimmed = name.trim();
    if (!StringUtils.isEmpty(trimmed)) {
      if (caseToParam.equalsIgnoreCase("upper")) {
        return trimmed.substring(0, 1).toUpperCase(Locale.ROOT) + suffixParam;
      } else {
        return trimmed.substring(0, 1).toLowerCase(Locale.ROOT) + suffixParam;
      }
    }
    return name;

  }

}
