/*-
 * =================================LICENSE_START=================================
 * IND2UCE
 * %%
 * Copyright (C) 2016 Fraunhofer IESE (www.iese.fraunhofer.de)
 * %%
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * =================================LICENSE_END=================================
 */

package de.fraunhofer.iese.ind2uce.pep.modifiermethods;

import de.fraunhofer.iese.ind2uce.api.policy.parameter.ParameterList;
import de.fraunhofer.iese.ind2uce.pep.common.PrimitiveModifierMethod;
import de.fraunhofer.iese.ind2uce.registry.ActionDescription;
import de.fraunhofer.iese.ind2uce.registry.ActionParameterDescription;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

/****
 * NOTE: This method does not anagram the string as primitive or json . It just
 * jumbles up the letters of the word so string does not make any sense.
 * Implementation is subject to change for later needs. It produces anagram of a
 * given string.
 */
public class RangeModifierMethod extends PrimitiveModifierMethod {

  private static Logger LOG = LoggerFactory.getLogger(RangeModifierMethod.class);

  @Override
  public Object doModification(Object currentObject, ParameterList modifierMethodParameterList) {
    final Object pivot = modifierMethodParameterList.getParameterValueForName("pivot");
    final int pivotParam = pivot != null ? (int)Math.round(Double.parseDouble(String.valueOf(pivot))) : 0;

    return this.range(currentObject.toString(), pivotParam);
  }

  /**
   * Gets the range.
   *
   * @param inputString the input string
   * @param pivot the pivot
   * @return the range
   */
  @ActionDescription(description = "finds the range of the given number", pepSupportedType = String.class)
  public String range(String inputString,
                         @ActionParameterDescription(name = "pivot", description = "The value which measures the requested range", mandatory = true, type = java.lang.Integer.class) int pivot) {

    if (StringUtils.isEmpty(inputString)) {
      return inputString;
    }

    String result = "";
    if (inputString.contains(".")) {
      float givenFloat = Float.parseFloat(String.valueOf(inputString));
      float upbound = 0;
      while (upbound < givenFloat) {
        upbound += pivot;
      }
      float down = upbound - pivot;
      result = down + "-" + upbound;
    } else {
      int givenInt = Integer.parseInt(String.valueOf(inputString));
      int upbound = 0;
      while (upbound < givenInt) {
        upbound += pivot;
      }
      int down = upbound - pivot;
      result = down + "-" + upbound;
    }

    LOG.trace("Built range {}% of {} --> {}", pivot, inputString, result);
    return result;
  }

  /**
   * @return Display Name
   */
  @Override
  public String getDisplayName() {
    return "range";
  }

}
