/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iese.ind2uce.registry;

import de.fraunhofer.iese.ind2uce.api.component.Component;
import de.fraunhofer.iese.ind2uce.api.component.description.MethodInterfaceDescription;
import de.fraunhofer.iese.ind2uce.api.component.identifier.ComponentId;
import de.fraunhofer.iese.ind2uce.api.component.interfaces.IPolicyManagementPoint;
import de.fraunhofer.iese.ind2uce.logger.LoggerFactory;
import de.fraunhofer.iese.ind2uce.registry.ComponentType;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;

public class RegistryBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(RegistryBuilder.class);
    private final ComponentType componentType;
    private final IPolicyManagementPoint pmp;
    private final List<URI> urls = new ArrayList<URI>();
    private final List<MethodInterfaceDescription> interfaceDescriptions = new ArrayList<MethodInterfaceDescription>();
    private Component toRegister;
    private ComponentId componentId;

    public RegistryBuilder(ComponentType componentType, IPolicyManagementPoint registration) {
        this.componentType = componentType;
        this.pmp = registration;
    }

    public RegistryBuilder componentId(String componentId) {
        this.componentId = new ComponentId(this.componentType.getComponentIdPrefix() + ":" + componentId);
        return this;
    }

    public RegistryBuilder componentId(ComponentId componentId) {
        this.componentId = componentId;
        return this;
    }

    public RegistryBuilder addInterfaceDescription(MethodInterfaceDescription description) {
        this.interfaceDescriptions.add(description);
        return this;
    }

    public RegistryBuilder addAll(Set<MethodInterfaceDescription> interfaceDescriptions) {
        this.interfaceDescriptions.addAll(interfaceDescriptions);
        return this;
    }

    public RegistryBuilder addUri(String uri) {
        this.urls.add(URI.create(uri));
        return this;
    }

    public RegistryBuilder addUri(URI uri) {
        this.urls.add(uri);
        return this;
    }

    public boolean register() throws IOException {
        LOG.info("RegistrationProcess started..");
        this.toRegister = new Component(this.componentId);
        this.toRegister.setUrls(this.urls);
        this.toRegister.setComponentInterfaces(this.interfaceDescriptions);
        boolean registrationStatus = this.pmp.registerComponent(this.toRegister);
        if (registrationStatus) {
            LOG.info("Component {} successfully registered..", (Object)this.componentId);
        } else {
            LOG.warn("Component {} not registered", (Object)this.componentId);
        }
        return registrationStatus;
    }
}

